# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy

from .. import models as _models
from ..._serialization import Deserializer, Serializer
from ._configuration import NetworkManagementClientConfiguration
from .operations import (
    AdminRuleCollectionsOperations,
    AdminRulesOperations,
    ApplicationGatewayPrivateEndpointConnectionsOperations,
    ApplicationGatewayPrivateLinkResourcesOperations,
    ApplicationGatewayWafDynamicManifestsDefaultOperations,
    ApplicationGatewayWafDynamicManifestsOperations,
    ApplicationGatewaysOperations,
    ApplicationSecurityGroupsOperations,
    AvailableDelegationsOperations,
    AvailableEndpointServicesOperations,
    AvailablePrivateEndpointTypesOperations,
    AvailableResourceGroupDelegationsOperations,
    AvailableServiceAliasesOperations,
    AzureFirewallFqdnTagsOperations,
    AzureFirewallsOperations,
    BastionHostsOperations,
    BgpServiceCommunitiesOperations,
    ConfigurationPolicyGroupsOperations,
    ConnectionMonitorsOperations,
    ConnectivityConfigurationsOperations,
    CustomIPPrefixesOperations,
    DdosCustomPoliciesOperations,
    DdosProtectionPlansOperations,
    DefaultSecurityRulesOperations,
    DscpConfigurationOperations,
    ExpressRouteCircuitAuthorizationsOperations,
    ExpressRouteCircuitConnectionsOperations,
    ExpressRouteCircuitPeeringsOperations,
    ExpressRouteCircuitsOperations,
    ExpressRouteConnectionsOperations,
    ExpressRouteCrossConnectionPeeringsOperations,
    ExpressRouteCrossConnectionsOperations,
    ExpressRouteGatewaysOperations,
    ExpressRouteLinksOperations,
    ExpressRoutePortAuthorizationsOperations,
    ExpressRoutePortsLocationsOperations,
    ExpressRoutePortsOperations,
    ExpressRouteProviderPortsLocationOperations,
    ExpressRouteServiceProvidersOperations,
    FirewallPoliciesOperations,
    FirewallPolicyDeploymentsOperations,
    FirewallPolicyDraftsOperations,
    FirewallPolicyIdpsSignaturesFilterValuesOperations,
    FirewallPolicyIdpsSignaturesOperations,
    FirewallPolicyIdpsSignaturesOverridesOperations,
    FirewallPolicyRuleCollectionGroupDraftsOperations,
    FirewallPolicyRuleCollectionGroupsOperations,
    FlowLogsOperations,
    HubRouteTablesOperations,
    HubVirtualNetworkConnectionsOperations,
    InboundNatRulesOperations,
    InboundSecurityRuleOperations,
    IpAllocationsOperations,
    IpGroupsOperations,
    LoadBalancerBackendAddressPoolsOperations,
    LoadBalancerFrontendIPConfigurationsOperations,
    LoadBalancerLoadBalancingRulesOperations,
    LoadBalancerNetworkInterfacesOperations,
    LoadBalancerOutboundRulesOperations,
    LoadBalancerProbesOperations,
    LoadBalancersOperations,
    LocalNetworkGatewaysOperations,
    ManagementGroupNetworkManagerConnectionsOperations,
    NatGatewaysOperations,
    NatRulesOperations,
    NetworkGroupsOperations,
    NetworkInterfaceIPConfigurationsOperations,
    NetworkInterfaceLoadBalancersOperations,
    NetworkInterfaceTapConfigurationsOperations,
    NetworkInterfacesOperations,
    NetworkManagementClientOperationsMixin,
    NetworkManagerCommitsOperations,
    NetworkManagerDeploymentStatusOperations,
    NetworkManagersOperations,
    NetworkProfilesOperations,
    NetworkSecurityGroupsOperations,
    NetworkVirtualApplianceConnectionsOperations,
    NetworkVirtualAppliancesOperations,
    NetworkWatchersOperations,
    Operations,
    P2SVpnGatewaysOperations,
    PacketCapturesOperations,
    PeerExpressRouteCircuitConnectionsOperations,
    PrivateDnsZoneGroupsOperations,
    PrivateEndpointsOperations,
    PrivateLinkServicesOperations,
    PublicIPAddressesOperations,
    PublicIPPrefixesOperations,
    ResourceNavigationLinksOperations,
    RouteFilterRulesOperations,
    RouteFiltersOperations,
    RouteMapsOperations,
    RouteTablesOperations,
    RoutesOperations,
    RoutingIntentOperations,
    ScopeConnectionsOperations,
    SecurityAdminConfigurationsOperations,
    SecurityPartnerProvidersOperations,
    SecurityRulesOperations,
    ServiceAssociationLinksOperations,
    ServiceEndpointPoliciesOperations,
    ServiceEndpointPolicyDefinitionsOperations,
    ServiceTagInformationOperations,
    ServiceTagsOperations,
    StaticMembersOperations,
    SubnetsOperations,
    SubscriptionNetworkManagerConnectionsOperations,
    UsagesOperations,
    VipSwapOperations,
    VirtualApplianceSitesOperations,
    VirtualApplianceSkusOperations,
    VirtualHubBgpConnectionOperations,
    VirtualHubBgpConnectionsOperations,
    VirtualHubIpConfigurationOperations,
    VirtualHubRouteTableV2SOperations,
    VirtualHubsOperations,
    VirtualNetworkGatewayConnectionsOperations,
    VirtualNetworkGatewayNatRulesOperations,
    VirtualNetworkGatewaysOperations,
    VirtualNetworkPeeringsOperations,
    VirtualNetworkTapsOperations,
    VirtualNetworksOperations,
    VirtualRouterPeeringsOperations,
    VirtualRoutersOperations,
    VirtualWansOperations,
    VpnConnectionsOperations,
    VpnGatewaysOperations,
    VpnLinkConnectionsOperations,
    VpnServerConfigurationsAssociatedWithVirtualWanOperations,
    VpnServerConfigurationsOperations,
    VpnSiteLinkConnectionsOperations,
    VpnSiteLinksOperations,
    VpnSitesConfigurationOperations,
    VpnSitesOperations,
    WebApplicationFirewallPoliciesOperations,
    WebCategoriesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class NetworkManagementClient(
    NetworkManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Network Client.

    :ivar application_gateways: ApplicationGatewaysOperations operations
    :vartype application_gateways:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationGatewaysOperations
    :ivar application_gateway_private_link_resources:
     ApplicationGatewayPrivateLinkResourcesOperations operations
    :vartype application_gateway_private_link_resources:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationGatewayPrivateLinkResourcesOperations
    :ivar application_gateway_private_endpoint_connections:
     ApplicationGatewayPrivateEndpointConnectionsOperations operations
    :vartype application_gateway_private_endpoint_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationGatewayPrivateEndpointConnectionsOperations
    :ivar application_gateway_waf_dynamic_manifests_default:
     ApplicationGatewayWafDynamicManifestsDefaultOperations operations
    :vartype application_gateway_waf_dynamic_manifests_default:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationGatewayWafDynamicManifestsDefaultOperations
    :ivar application_gateway_waf_dynamic_manifests:
     ApplicationGatewayWafDynamicManifestsOperations operations
    :vartype application_gateway_waf_dynamic_manifests:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationGatewayWafDynamicManifestsOperations
    :ivar application_security_groups: ApplicationSecurityGroupsOperations operations
    :vartype application_security_groups:
     azure.mgmt.network.v2024_01_01.aio.operations.ApplicationSecurityGroupsOperations
    :ivar available_delegations: AvailableDelegationsOperations operations
    :vartype available_delegations:
     azure.mgmt.network.v2024_01_01.aio.operations.AvailableDelegationsOperations
    :ivar available_resource_group_delegations: AvailableResourceGroupDelegationsOperations
     operations
    :vartype available_resource_group_delegations:
     azure.mgmt.network.v2024_01_01.aio.operations.AvailableResourceGroupDelegationsOperations
    :ivar available_service_aliases: AvailableServiceAliasesOperations operations
    :vartype available_service_aliases:
     azure.mgmt.network.v2024_01_01.aio.operations.AvailableServiceAliasesOperations
    :ivar azure_firewalls: AzureFirewallsOperations operations
    :vartype azure_firewalls:
     azure.mgmt.network.v2024_01_01.aio.operations.AzureFirewallsOperations
    :ivar azure_firewall_fqdn_tags: AzureFirewallFqdnTagsOperations operations
    :vartype azure_firewall_fqdn_tags:
     azure.mgmt.network.v2024_01_01.aio.operations.AzureFirewallFqdnTagsOperations
    :ivar web_categories: WebCategoriesOperations operations
    :vartype web_categories: azure.mgmt.network.v2024_01_01.aio.operations.WebCategoriesOperations
    :ivar bastion_hosts: BastionHostsOperations operations
    :vartype bastion_hosts: azure.mgmt.network.v2024_01_01.aio.operations.BastionHostsOperations
    :ivar network_interfaces: NetworkInterfacesOperations operations
    :vartype network_interfaces:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkInterfacesOperations
    :ivar public_ip_addresses: PublicIPAddressesOperations operations
    :vartype public_ip_addresses:
     azure.mgmt.network.v2024_01_01.aio.operations.PublicIPAddressesOperations
    :ivar vip_swap: VipSwapOperations operations
    :vartype vip_swap: azure.mgmt.network.v2024_01_01.aio.operations.VipSwapOperations
    :ivar custom_ip_prefixes: CustomIPPrefixesOperations operations
    :vartype custom_ip_prefixes:
     azure.mgmt.network.v2024_01_01.aio.operations.CustomIPPrefixesOperations
    :ivar ddos_custom_policies: DdosCustomPoliciesOperations operations
    :vartype ddos_custom_policies:
     azure.mgmt.network.v2024_01_01.aio.operations.DdosCustomPoliciesOperations
    :ivar ddos_protection_plans: DdosProtectionPlansOperations operations
    :vartype ddos_protection_plans:
     azure.mgmt.network.v2024_01_01.aio.operations.DdosProtectionPlansOperations
    :ivar dscp_configuration: DscpConfigurationOperations operations
    :vartype dscp_configuration:
     azure.mgmt.network.v2024_01_01.aio.operations.DscpConfigurationOperations
    :ivar available_endpoint_services: AvailableEndpointServicesOperations operations
    :vartype available_endpoint_services:
     azure.mgmt.network.v2024_01_01.aio.operations.AvailableEndpointServicesOperations
    :ivar express_route_circuit_authorizations: ExpressRouteCircuitAuthorizationsOperations
     operations
    :vartype express_route_circuit_authorizations:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCircuitAuthorizationsOperations
    :ivar express_route_circuit_peerings: ExpressRouteCircuitPeeringsOperations operations
    :vartype express_route_circuit_peerings:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCircuitPeeringsOperations
    :ivar express_route_circuit_connections: ExpressRouteCircuitConnectionsOperations operations
    :vartype express_route_circuit_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCircuitConnectionsOperations
    :ivar peer_express_route_circuit_connections: PeerExpressRouteCircuitConnectionsOperations
     operations
    :vartype peer_express_route_circuit_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.PeerExpressRouteCircuitConnectionsOperations
    :ivar express_route_circuits: ExpressRouteCircuitsOperations operations
    :vartype express_route_circuits:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCircuitsOperations
    :ivar express_route_service_providers: ExpressRouteServiceProvidersOperations operations
    :vartype express_route_service_providers:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteServiceProvidersOperations
    :ivar express_route_cross_connections: ExpressRouteCrossConnectionsOperations operations
    :vartype express_route_cross_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCrossConnectionsOperations
    :ivar express_route_cross_connection_peerings: ExpressRouteCrossConnectionPeeringsOperations
     operations
    :vartype express_route_cross_connection_peerings:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteCrossConnectionPeeringsOperations
    :ivar express_route_ports_locations: ExpressRoutePortsLocationsOperations operations
    :vartype express_route_ports_locations:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRoutePortsLocationsOperations
    :ivar express_route_ports: ExpressRoutePortsOperations operations
    :vartype express_route_ports:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRoutePortsOperations
    :ivar express_route_links: ExpressRouteLinksOperations operations
    :vartype express_route_links:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteLinksOperations
    :ivar express_route_port_authorizations: ExpressRoutePortAuthorizationsOperations operations
    :vartype express_route_port_authorizations:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRoutePortAuthorizationsOperations
    :ivar express_route_provider_ports_location: ExpressRouteProviderPortsLocationOperations
     operations
    :vartype express_route_provider_ports_location:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteProviderPortsLocationOperations
    :ivar firewall_policies: FirewallPoliciesOperations operations
    :vartype firewall_policies:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPoliciesOperations
    :ivar firewall_policy_rule_collection_groups: FirewallPolicyRuleCollectionGroupsOperations
     operations
    :vartype firewall_policy_rule_collection_groups:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyRuleCollectionGroupsOperations
    :ivar firewall_policy_idps_signatures: FirewallPolicyIdpsSignaturesOperations operations
    :vartype firewall_policy_idps_signatures:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyIdpsSignaturesOperations
    :ivar firewall_policy_idps_signatures_overrides:
     FirewallPolicyIdpsSignaturesOverridesOperations operations
    :vartype firewall_policy_idps_signatures_overrides:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyIdpsSignaturesOverridesOperations
    :ivar firewall_policy_idps_signatures_filter_values:
     FirewallPolicyIdpsSignaturesFilterValuesOperations operations
    :vartype firewall_policy_idps_signatures_filter_values:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyIdpsSignaturesFilterValuesOperations
    :ivar firewall_policy_drafts: FirewallPolicyDraftsOperations operations
    :vartype firewall_policy_drafts:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyDraftsOperations
    :ivar firewall_policy_deployments: FirewallPolicyDeploymentsOperations operations
    :vartype firewall_policy_deployments:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyDeploymentsOperations
    :ivar firewall_policy_rule_collection_group_drafts:
     FirewallPolicyRuleCollectionGroupDraftsOperations operations
    :vartype firewall_policy_rule_collection_group_drafts:
     azure.mgmt.network.v2024_01_01.aio.operations.FirewallPolicyRuleCollectionGroupDraftsOperations
    :ivar ip_allocations: IpAllocationsOperations operations
    :vartype ip_allocations: azure.mgmt.network.v2024_01_01.aio.operations.IpAllocationsOperations
    :ivar ip_groups: IpGroupsOperations operations
    :vartype ip_groups: azure.mgmt.network.v2024_01_01.aio.operations.IpGroupsOperations
    :ivar load_balancers: LoadBalancersOperations operations
    :vartype load_balancers: azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancersOperations
    :ivar load_balancer_backend_address_pools: LoadBalancerBackendAddressPoolsOperations operations
    :vartype load_balancer_backend_address_pools:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerBackendAddressPoolsOperations
    :ivar load_balancer_frontend_ip_configurations: LoadBalancerFrontendIPConfigurationsOperations
     operations
    :vartype load_balancer_frontend_ip_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerFrontendIPConfigurationsOperations
    :ivar inbound_nat_rules: InboundNatRulesOperations operations
    :vartype inbound_nat_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.InboundNatRulesOperations
    :ivar load_balancer_load_balancing_rules: LoadBalancerLoadBalancingRulesOperations operations
    :vartype load_balancer_load_balancing_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerLoadBalancingRulesOperations
    :ivar load_balancer_outbound_rules: LoadBalancerOutboundRulesOperations operations
    :vartype load_balancer_outbound_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerOutboundRulesOperations
    :ivar load_balancer_network_interfaces: LoadBalancerNetworkInterfacesOperations operations
    :vartype load_balancer_network_interfaces:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerNetworkInterfacesOperations
    :ivar load_balancer_probes: LoadBalancerProbesOperations operations
    :vartype load_balancer_probes:
     azure.mgmt.network.v2024_01_01.aio.operations.LoadBalancerProbesOperations
    :ivar nat_gateways: NatGatewaysOperations operations
    :vartype nat_gateways: azure.mgmt.network.v2024_01_01.aio.operations.NatGatewaysOperations
    :ivar network_interface_ip_configurations: NetworkInterfaceIPConfigurationsOperations
     operations
    :vartype network_interface_ip_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkInterfaceIPConfigurationsOperations
    :ivar network_interface_load_balancers: NetworkInterfaceLoadBalancersOperations operations
    :vartype network_interface_load_balancers:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkInterfaceLoadBalancersOperations
    :ivar network_interface_tap_configurations: NetworkInterfaceTapConfigurationsOperations
     operations
    :vartype network_interface_tap_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkInterfaceTapConfigurationsOperations
    :ivar network_managers: NetworkManagersOperations operations
    :vartype network_managers:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkManagersOperations
    :ivar network_manager_commits: NetworkManagerCommitsOperations operations
    :vartype network_manager_commits:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkManagerCommitsOperations
    :ivar network_manager_deployment_status: NetworkManagerDeploymentStatusOperations operations
    :vartype network_manager_deployment_status:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkManagerDeploymentStatusOperations
    :ivar subscription_network_manager_connections: SubscriptionNetworkManagerConnectionsOperations
     operations
    :vartype subscription_network_manager_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.SubscriptionNetworkManagerConnectionsOperations
    :ivar management_group_network_manager_connections:
     ManagementGroupNetworkManagerConnectionsOperations operations
    :vartype management_group_network_manager_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ManagementGroupNetworkManagerConnectionsOperations
    :ivar connectivity_configurations: ConnectivityConfigurationsOperations operations
    :vartype connectivity_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.ConnectivityConfigurationsOperations
    :ivar network_groups: NetworkGroupsOperations operations
    :vartype network_groups: azure.mgmt.network.v2024_01_01.aio.operations.NetworkGroupsOperations
    :ivar static_members: StaticMembersOperations operations
    :vartype static_members: azure.mgmt.network.v2024_01_01.aio.operations.StaticMembersOperations
    :ivar scope_connections: ScopeConnectionsOperations operations
    :vartype scope_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ScopeConnectionsOperations
    :ivar security_admin_configurations: SecurityAdminConfigurationsOperations operations
    :vartype security_admin_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.SecurityAdminConfigurationsOperations
    :ivar admin_rule_collections: AdminRuleCollectionsOperations operations
    :vartype admin_rule_collections:
     azure.mgmt.network.v2024_01_01.aio.operations.AdminRuleCollectionsOperations
    :ivar admin_rules: AdminRulesOperations operations
    :vartype admin_rules: azure.mgmt.network.v2024_01_01.aio.operations.AdminRulesOperations
    :ivar network_profiles: NetworkProfilesOperations operations
    :vartype network_profiles:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkProfilesOperations
    :ivar network_security_groups: NetworkSecurityGroupsOperations operations
    :vartype network_security_groups:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkSecurityGroupsOperations
    :ivar security_rules: SecurityRulesOperations operations
    :vartype security_rules: azure.mgmt.network.v2024_01_01.aio.operations.SecurityRulesOperations
    :ivar default_security_rules: DefaultSecurityRulesOperations operations
    :vartype default_security_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.DefaultSecurityRulesOperations
    :ivar network_virtual_appliances: NetworkVirtualAppliancesOperations operations
    :vartype network_virtual_appliances:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkVirtualAppliancesOperations
    :ivar virtual_appliance_sites: VirtualApplianceSitesOperations operations
    :vartype virtual_appliance_sites:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualApplianceSitesOperations
    :ivar virtual_appliance_skus: VirtualApplianceSkusOperations operations
    :vartype virtual_appliance_skus:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualApplianceSkusOperations
    :ivar inbound_security_rule: InboundSecurityRuleOperations operations
    :vartype inbound_security_rule:
     azure.mgmt.network.v2024_01_01.aio.operations.InboundSecurityRuleOperations
    :ivar network_watchers: NetworkWatchersOperations operations
    :vartype network_watchers:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkWatchersOperations
    :ivar packet_captures: PacketCapturesOperations operations
    :vartype packet_captures:
     azure.mgmt.network.v2024_01_01.aio.operations.PacketCapturesOperations
    :ivar connection_monitors: ConnectionMonitorsOperations operations
    :vartype connection_monitors:
     azure.mgmt.network.v2024_01_01.aio.operations.ConnectionMonitorsOperations
    :ivar flow_logs: FlowLogsOperations operations
    :vartype flow_logs: azure.mgmt.network.v2024_01_01.aio.operations.FlowLogsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.network.v2024_01_01.aio.operations.Operations
    :ivar private_endpoints: PrivateEndpointsOperations operations
    :vartype private_endpoints:
     azure.mgmt.network.v2024_01_01.aio.operations.PrivateEndpointsOperations
    :ivar available_private_endpoint_types: AvailablePrivateEndpointTypesOperations operations
    :vartype available_private_endpoint_types:
     azure.mgmt.network.v2024_01_01.aio.operations.AvailablePrivateEndpointTypesOperations
    :ivar private_dns_zone_groups: PrivateDnsZoneGroupsOperations operations
    :vartype private_dns_zone_groups:
     azure.mgmt.network.v2024_01_01.aio.operations.PrivateDnsZoneGroupsOperations
    :ivar private_link_services: PrivateLinkServicesOperations operations
    :vartype private_link_services:
     azure.mgmt.network.v2024_01_01.aio.operations.PrivateLinkServicesOperations
    :ivar public_ip_prefixes: PublicIPPrefixesOperations operations
    :vartype public_ip_prefixes:
     azure.mgmt.network.v2024_01_01.aio.operations.PublicIPPrefixesOperations
    :ivar route_filters: RouteFiltersOperations operations
    :vartype route_filters: azure.mgmt.network.v2024_01_01.aio.operations.RouteFiltersOperations
    :ivar route_filter_rules: RouteFilterRulesOperations operations
    :vartype route_filter_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.RouteFilterRulesOperations
    :ivar route_tables: RouteTablesOperations operations
    :vartype route_tables: azure.mgmt.network.v2024_01_01.aio.operations.RouteTablesOperations
    :ivar routes: RoutesOperations operations
    :vartype routes: azure.mgmt.network.v2024_01_01.aio.operations.RoutesOperations
    :ivar security_partner_providers: SecurityPartnerProvidersOperations operations
    :vartype security_partner_providers:
     azure.mgmt.network.v2024_01_01.aio.operations.SecurityPartnerProvidersOperations
    :ivar bgp_service_communities: BgpServiceCommunitiesOperations operations
    :vartype bgp_service_communities:
     azure.mgmt.network.v2024_01_01.aio.operations.BgpServiceCommunitiesOperations
    :ivar service_endpoint_policies: ServiceEndpointPoliciesOperations operations
    :vartype service_endpoint_policies:
     azure.mgmt.network.v2024_01_01.aio.operations.ServiceEndpointPoliciesOperations
    :ivar service_endpoint_policy_definitions: ServiceEndpointPolicyDefinitionsOperations
     operations
    :vartype service_endpoint_policy_definitions:
     azure.mgmt.network.v2024_01_01.aio.operations.ServiceEndpointPolicyDefinitionsOperations
    :ivar service_tags: ServiceTagsOperations operations
    :vartype service_tags: azure.mgmt.network.v2024_01_01.aio.operations.ServiceTagsOperations
    :ivar service_tag_information: ServiceTagInformationOperations operations
    :vartype service_tag_information:
     azure.mgmt.network.v2024_01_01.aio.operations.ServiceTagInformationOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.network.v2024_01_01.aio.operations.UsagesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworksOperations
    :ivar subnets: SubnetsOperations operations
    :vartype subnets: azure.mgmt.network.v2024_01_01.aio.operations.SubnetsOperations
    :ivar resource_navigation_links: ResourceNavigationLinksOperations operations
    :vartype resource_navigation_links:
     azure.mgmt.network.v2024_01_01.aio.operations.ResourceNavigationLinksOperations
    :ivar service_association_links: ServiceAssociationLinksOperations operations
    :vartype service_association_links:
     azure.mgmt.network.v2024_01_01.aio.operations.ServiceAssociationLinksOperations
    :ivar virtual_network_peerings: VirtualNetworkPeeringsOperations operations
    :vartype virtual_network_peerings:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworkPeeringsOperations
    :ivar virtual_network_gateways: VirtualNetworkGatewaysOperations operations
    :vartype virtual_network_gateways:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworkGatewaysOperations
    :ivar virtual_network_gateway_connections: VirtualNetworkGatewayConnectionsOperations
     operations
    :vartype virtual_network_gateway_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworkGatewayConnectionsOperations
    :ivar local_network_gateways: LocalNetworkGatewaysOperations operations
    :vartype local_network_gateways:
     azure.mgmt.network.v2024_01_01.aio.operations.LocalNetworkGatewaysOperations
    :ivar virtual_network_gateway_nat_rules: VirtualNetworkGatewayNatRulesOperations operations
    :vartype virtual_network_gateway_nat_rules:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworkGatewayNatRulesOperations
    :ivar virtual_network_taps: VirtualNetworkTapsOperations operations
    :vartype virtual_network_taps:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualNetworkTapsOperations
    :ivar virtual_routers: VirtualRoutersOperations operations
    :vartype virtual_routers:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualRoutersOperations
    :ivar virtual_router_peerings: VirtualRouterPeeringsOperations operations
    :vartype virtual_router_peerings:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualRouterPeeringsOperations
    :ivar virtual_wans: VirtualWansOperations operations
    :vartype virtual_wans: azure.mgmt.network.v2024_01_01.aio.operations.VirtualWansOperations
    :ivar vpn_sites: VpnSitesOperations operations
    :vartype vpn_sites: azure.mgmt.network.v2024_01_01.aio.operations.VpnSitesOperations
    :ivar vpn_site_links: VpnSiteLinksOperations operations
    :vartype vpn_site_links: azure.mgmt.network.v2024_01_01.aio.operations.VpnSiteLinksOperations
    :ivar vpn_sites_configuration: VpnSitesConfigurationOperations operations
    :vartype vpn_sites_configuration:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnSitesConfigurationOperations
    :ivar vpn_server_configurations: VpnServerConfigurationsOperations operations
    :vartype vpn_server_configurations:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnServerConfigurationsOperations
    :ivar configuration_policy_groups: ConfigurationPolicyGroupsOperations operations
    :vartype configuration_policy_groups:
     azure.mgmt.network.v2024_01_01.aio.operations.ConfigurationPolicyGroupsOperations
    :ivar virtual_hubs: VirtualHubsOperations operations
    :vartype virtual_hubs: azure.mgmt.network.v2024_01_01.aio.operations.VirtualHubsOperations
    :ivar route_maps: RouteMapsOperations operations
    :vartype route_maps: azure.mgmt.network.v2024_01_01.aio.operations.RouteMapsOperations
    :ivar hub_virtual_network_connections: HubVirtualNetworkConnectionsOperations operations
    :vartype hub_virtual_network_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.HubVirtualNetworkConnectionsOperations
    :ivar vpn_gateways: VpnGatewaysOperations operations
    :vartype vpn_gateways: azure.mgmt.network.v2024_01_01.aio.operations.VpnGatewaysOperations
    :ivar vpn_link_connections: VpnLinkConnectionsOperations operations
    :vartype vpn_link_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnLinkConnectionsOperations
    :ivar vpn_connections: VpnConnectionsOperations operations
    :vartype vpn_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnConnectionsOperations
    :ivar vpn_site_link_connections: VpnSiteLinkConnectionsOperations operations
    :vartype vpn_site_link_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnSiteLinkConnectionsOperations
    :ivar nat_rules: NatRulesOperations operations
    :vartype nat_rules: azure.mgmt.network.v2024_01_01.aio.operations.NatRulesOperations
    :ivar p2_svpn_gateways: P2SVpnGatewaysOperations operations
    :vartype p2_svpn_gateways:
     azure.mgmt.network.v2024_01_01.aio.operations.P2SVpnGatewaysOperations
    :ivar vpn_server_configurations_associated_with_virtual_wan:
     VpnServerConfigurationsAssociatedWithVirtualWanOperations operations
    :vartype vpn_server_configurations_associated_with_virtual_wan:
     azure.mgmt.network.v2024_01_01.aio.operations.VpnServerConfigurationsAssociatedWithVirtualWanOperations
    :ivar virtual_hub_route_table_v2_s: VirtualHubRouteTableV2SOperations operations
    :vartype virtual_hub_route_table_v2_s:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualHubRouteTableV2SOperations
    :ivar express_route_gateways: ExpressRouteGatewaysOperations operations
    :vartype express_route_gateways:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteGatewaysOperations
    :ivar express_route_connections: ExpressRouteConnectionsOperations operations
    :vartype express_route_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.ExpressRouteConnectionsOperations
    :ivar network_virtual_appliance_connections: NetworkVirtualApplianceConnectionsOperations
     operations
    :vartype network_virtual_appliance_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.NetworkVirtualApplianceConnectionsOperations
    :ivar virtual_hub_bgp_connection: VirtualHubBgpConnectionOperations operations
    :vartype virtual_hub_bgp_connection:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualHubBgpConnectionOperations
    :ivar virtual_hub_bgp_connections: VirtualHubBgpConnectionsOperations operations
    :vartype virtual_hub_bgp_connections:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualHubBgpConnectionsOperations
    :ivar virtual_hub_ip_configuration: VirtualHubIpConfigurationOperations operations
    :vartype virtual_hub_ip_configuration:
     azure.mgmt.network.v2024_01_01.aio.operations.VirtualHubIpConfigurationOperations
    :ivar hub_route_tables: HubRouteTablesOperations operations
    :vartype hub_route_tables:
     azure.mgmt.network.v2024_01_01.aio.operations.HubRouteTablesOperations
    :ivar routing_intent: RoutingIntentOperations operations
    :vartype routing_intent: azure.mgmt.network.v2024_01_01.aio.operations.RoutingIntentOperations
    :ivar web_application_firewall_policies: WebApplicationFirewallPoliciesOperations operations
    :vartype web_application_firewall_policies:
     azure.mgmt.network.v2024_01_01.aio.operations.WebApplicationFirewallPoliciesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The subscription credentials which uniquely identify the Microsoft
     Azure subscription. The subscription ID forms part of the URI for every service call. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = NetworkManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.application_gateways = ApplicationGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.application_gateway_private_link_resources = ApplicationGatewayPrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.application_gateway_private_endpoint_connections = ApplicationGatewayPrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.application_gateway_waf_dynamic_manifests_default = ApplicationGatewayWafDynamicManifestsDefaultOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.application_gateway_waf_dynamic_manifests = ApplicationGatewayWafDynamicManifestsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.application_security_groups = ApplicationSecurityGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.available_delegations = AvailableDelegationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.available_resource_group_delegations = AvailableResourceGroupDelegationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.available_service_aliases = AvailableServiceAliasesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.azure_firewalls = AzureFirewallsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.azure_firewall_fqdn_tags = AzureFirewallFqdnTagsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.web_categories = WebCategoriesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.bastion_hosts = BastionHostsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_interfaces = NetworkInterfacesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.public_ip_addresses = PublicIPAddressesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vip_swap = VipSwapOperations(self._client, self._config, self._serialize, self._deserialize, "2024-01-01")
        self.custom_ip_prefixes = CustomIPPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.ddos_custom_policies = DdosCustomPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.ddos_protection_plans = DdosProtectionPlansOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.dscp_configuration = DscpConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.available_endpoint_services = AvailableEndpointServicesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_circuit_authorizations = ExpressRouteCircuitAuthorizationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_circuit_peerings = ExpressRouteCircuitPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_circuit_connections = ExpressRouteCircuitConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.peer_express_route_circuit_connections = PeerExpressRouteCircuitConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_circuits = ExpressRouteCircuitsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_service_providers = ExpressRouteServiceProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_cross_connections = ExpressRouteCrossConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_cross_connection_peerings = ExpressRouteCrossConnectionPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_ports_locations = ExpressRoutePortsLocationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_ports = ExpressRoutePortsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_links = ExpressRouteLinksOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_port_authorizations = ExpressRoutePortAuthorizationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_provider_ports_location = ExpressRouteProviderPortsLocationOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policies = FirewallPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_rule_collection_groups = FirewallPolicyRuleCollectionGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_idps_signatures = FirewallPolicyIdpsSignaturesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_idps_signatures_overrides = FirewallPolicyIdpsSignaturesOverridesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_idps_signatures_filter_values = FirewallPolicyIdpsSignaturesFilterValuesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_drafts = FirewallPolicyDraftsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_deployments = FirewallPolicyDeploymentsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.firewall_policy_rule_collection_group_drafts = FirewallPolicyRuleCollectionGroupDraftsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.ip_allocations = IpAllocationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.ip_groups = IpGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancers = LoadBalancersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_backend_address_pools = LoadBalancerBackendAddressPoolsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_frontend_ip_configurations = LoadBalancerFrontendIPConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.inbound_nat_rules = InboundNatRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_load_balancing_rules = LoadBalancerLoadBalancingRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_outbound_rules = LoadBalancerOutboundRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_network_interfaces = LoadBalancerNetworkInterfacesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.load_balancer_probes = LoadBalancerProbesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.nat_gateways = NatGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_interface_ip_configurations = NetworkInterfaceIPConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_interface_load_balancers = NetworkInterfaceLoadBalancersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_interface_tap_configurations = NetworkInterfaceTapConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_managers = NetworkManagersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_manager_commits = NetworkManagerCommitsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_manager_deployment_status = NetworkManagerDeploymentStatusOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.subscription_network_manager_connections = SubscriptionNetworkManagerConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.management_group_network_manager_connections = ManagementGroupNetworkManagerConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.connectivity_configurations = ConnectivityConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_groups = NetworkGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.static_members = StaticMembersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.scope_connections = ScopeConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.security_admin_configurations = SecurityAdminConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.admin_rule_collections = AdminRuleCollectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.admin_rules = AdminRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_profiles = NetworkProfilesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_security_groups = NetworkSecurityGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.security_rules = SecurityRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.default_security_rules = DefaultSecurityRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_virtual_appliances = NetworkVirtualAppliancesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_appliance_sites = VirtualApplianceSitesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_appliance_skus = VirtualApplianceSkusOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.inbound_security_rule = InboundSecurityRuleOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_watchers = NetworkWatchersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.packet_captures = PacketCapturesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.connection_monitors = ConnectionMonitorsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.flow_logs = FlowLogsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize, "2024-01-01")
        self.private_endpoints = PrivateEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.available_private_endpoint_types = AvailablePrivateEndpointTypesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.private_dns_zone_groups = PrivateDnsZoneGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.private_link_services = PrivateLinkServicesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.public_ip_prefixes = PublicIPPrefixesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.route_filters = RouteFiltersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.route_filter_rules = RouteFilterRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.route_tables = RouteTablesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.routes = RoutesOperations(self._client, self._config, self._serialize, self._deserialize, "2024-01-01")
        self.security_partner_providers = SecurityPartnerProvidersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.bgp_service_communities = BgpServiceCommunitiesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.service_endpoint_policies = ServiceEndpointPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.service_endpoint_policy_definitions = ServiceEndpointPolicyDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.service_tags = ServiceTagsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.service_tag_information = ServiceTagInformationOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize, "2024-01-01")
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.subnets = SubnetsOperations(self._client, self._config, self._serialize, self._deserialize, "2024-01-01")
        self.resource_navigation_links = ResourceNavigationLinksOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.service_association_links = ServiceAssociationLinksOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_network_peerings = VirtualNetworkPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_network_gateways = VirtualNetworkGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_network_gateway_connections = VirtualNetworkGatewayConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.local_network_gateways = LocalNetworkGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_network_gateway_nat_rules = VirtualNetworkGatewayNatRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_network_taps = VirtualNetworkTapsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_routers = VirtualRoutersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_router_peerings = VirtualRouterPeeringsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_wans = VirtualWansOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_sites = VpnSitesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_site_links = VpnSiteLinksOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_sites_configuration = VpnSitesConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_server_configurations = VpnServerConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.configuration_policy_groups = ConfigurationPolicyGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_hubs = VirtualHubsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.route_maps = RouteMapsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.hub_virtual_network_connections = HubVirtualNetworkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_gateways = VpnGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_link_connections = VpnLinkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_connections = VpnConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_site_link_connections = VpnSiteLinkConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.nat_rules = NatRulesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.p2_svpn_gateways = P2SVpnGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.vpn_server_configurations_associated_with_virtual_wan = (
            VpnServerConfigurationsAssociatedWithVirtualWanOperations(
                self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
            )
        )
        self.virtual_hub_route_table_v2_s = VirtualHubRouteTableV2SOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_gateways = ExpressRouteGatewaysOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.express_route_connections = ExpressRouteConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.network_virtual_appliance_connections = NetworkVirtualApplianceConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_hub_bgp_connection = VirtualHubBgpConnectionOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_hub_bgp_connections = VirtualHubBgpConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.virtual_hub_ip_configuration = VirtualHubIpConfigurationOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.hub_route_tables = HubRouteTablesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.routing_intent = RoutingIntentOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )
        self.web_application_firewall_policies = WebApplicationFirewallPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2024-01-01"
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "NetworkManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
