# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible reasons for a name not being available."""

    INVALID = "Invalid"
    """Name is invalid."""
    ALREADY_EXISTS = "AlreadyExists"
    """Name already exists."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CreateMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The mode that the Mongo Cluster is created with."""

    DEFAULT = "Default"
    """Create a new mongo cluster."""
    POINT_IN_TIME_RESTORE = "PointInTimeRestore"
    """Create a mongo cluster from a restore point-in-time."""


class MongoClusterStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The status of the Mongo cluster resource."""

    READY = "Ready"
    """The mongo cluster resource is ready for use."""
    PROVISIONING = "Provisioning"
    """The mongo cluster resource is being provisioned."""
    UPDATING = "Updating"
    """The mongo cluster resource is being updated."""
    STARTING = "Starting"
    """The mongo cluster resource is being started."""
    STOPPING = "Stopping"
    """The mongo cluster resource is being stopped."""
    STOPPED = "Stopped"
    """The mongo cluster resource is stopped."""
    DROPPING = "Dropping"
    """The mongo cluster resource is being dropped."""


class NodeKind(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of the node on the cluster."""

    SHARD = "Shard"
    """The node is a shard kind."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PrivateEndpointConnectionProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current provisioning state."""

    SUCCEEDED = "Succeeded"
    """Connection has been provisioned"""
    CREATING = "Creating"
    """Connection is being created"""
    DELETING = "Deleting"
    """Connection is being deleted"""
    FAILED = "Failed"
    """Connection provisioning has failed"""


class PrivateEndpointServiceConnectionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The private endpoint connection status."""

    PENDING = "Pending"
    """Connectionaiting for approval or rejection"""
    APPROVED = "Approved"
    """Connection approved"""
    REJECTED = "Rejected"
    """Connection Rejected"""


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provisioning state of the last accepted operation."""

    SUCCEEDED = "Succeeded"
    """Resource has been created."""
    FAILED = "Failed"
    """Resource creation failed."""
    CANCELED = "Canceled"
    """Resource creation was canceled."""
    IN_PROGRESS = "InProgress"
    """An operation is in-progress on the resource."""
    UPDATING = "Updating"
    """An update operation is in-progress on the resource."""
    DROPPING = "Dropping"
    """A drop operation is in-progress on the resource."""


class PublicNetworkAccess(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Whether or not public endpoint access is allowed for this Mongo cluster.  Value is optional and
    default value is 'Enabled'.
    """

    ENABLED = "Enabled"
    """If set, mongo cluster can be accessed through private and public methods."""
    DISABLED = "Disabled"
    """If set, the private endpoints are the exclusive access method."""
