# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import sys
from typing import Any, Callable, Dict, IO, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ...operations._settings_operations import build_get_request, build_patch_request, build_update_request
from .._vendor import HybridComputeManagementClientMixinABC

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class SettingsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.hybridcompute.aio.HybridComputeManagementClient`'s
        :attr:`settings` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        **kwargs: Any
    ) -> _models.Settings:
        """Returns the base Settings for the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        cls: ClsType[_models.Settings] = kwargs.pop("cls", None)

        _request = build_get_request(
            resource_group_name=resource_group_name,
            base_provider=base_provider,
            base_resource_type=base_resource_type,
            base_resource_name=base_resource_name,
            settings_resource_name=settings_resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Settings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def update(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: _models.Settings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Settings:
        """Updates the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Required.
        :type parameters: ~azure.mgmt.hybridcompute.models.Settings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def update(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Settings:
        """Updates the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def update(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: Union[_models.Settings, IO[bytes]],
        **kwargs: Any
    ) -> _models.Settings:
        """Updates the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Is either a Settings type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.hybridcompute.models.Settings or IO[bytes]
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Settings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "Settings")

        _request = build_update_request(
            resource_group_name=resource_group_name,
            base_provider=base_provider,
            base_resource_type=base_resource_type,
            base_resource_name=base_resource_name,
            settings_resource_name=settings_resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if response.status_code == 200:
            deserialized = self._deserialize("Settings", pipeline_response.http_response)

        if response.status_code == 201:
            deserialized = self._deserialize("Settings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def patch(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: _models.Settings,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Settings:
        """Update the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Required.
        :type parameters: ~azure.mgmt.hybridcompute.models.Settings
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def patch(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.Settings:
        """Update the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Required.
        :type parameters: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def patch(
        self,
        resource_group_name: str,
        base_provider: str,
        base_resource_type: str,
        base_resource_name: str,
        settings_resource_name: str,
        parameters: Union[_models.Settings, IO[bytes]],
        **kwargs: Any
    ) -> _models.Settings:
        """Update the base Settings of the target resource.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param base_provider: The name of the base Resource Provider. Required.
        :type base_provider: str
        :param base_resource_type: The name of the base Resource Type. Required.
        :type base_resource_type: str
        :param base_resource_name: The name of the base resource. Required.
        :type base_resource_name: str
        :param settings_resource_name: The name of the settings resource. Required.
        :type settings_resource_name: str
        :param parameters: Settings details. Is either a Settings type or a IO[bytes] type. Required.
        :type parameters: ~azure.mgmt.hybridcompute.models.Settings or IO[bytes]
        :return: Settings or the result of cls(response)
        :rtype: ~azure.mgmt.hybridcompute.models.Settings
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", self._config.api_version))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Settings] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(parameters, (IOBase, bytes)):
            _content = parameters
        else:
            _json = self._serialize.body(parameters, "Settings")

        _request = build_patch_request(
            resource_group_name=resource_group_name,
            base_provider=base_provider,
            base_resource_type=base_resource_type,
            base_resource_name=base_resource_name,
            settings_resource_name=settings_resource_name,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("Settings", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
