# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.hdinsightcontainers import HDInsightContainersMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-hdinsightcontainers
# USAGE
    python patch_cluster.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HDInsightContainersMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="10e32bab-26da-4cc4-a441-52b318f824e6",
    )

    response = client.clusters.begin_update(
        resource_group_name="hiloResourcegroup",
        cluster_pool_name="clusterpool1",
        cluster_name="cluster1",
        cluster_patch_request={
            "properties": {
                "clusterProfile": {
                    "authorizationProfile": {"userIds": ["Testuser1", "Testuser2"]},
                    "autoscaleProfile": {
                        "autoscaleType": "ScheduleBased",
                        "enabled": True,
                        "gracefulDecommissionTimeout": -1,
                        "scheduleBasedConfig": {
                            "defaultCount": 3,
                            "schedules": [
                                {
                                    "count": 3,
                                    "days": ["Monday, Tuesday, Wednesday"],
                                    "endTime": "12:00",
                                    "startTime": "00:00",
                                },
                                {"count": 3, "days": ["Sunday"], "endTime": "12:00", "startTime": "00:00"},
                            ],
                            "timeZone": "Cen. Australia Standard Time",
                        },
                    },
                    "logAnalyticsProfile": {
                        "applicationLogs": {"stdErrorEnabled": True, "stdOutEnabled": True},
                        "enabled": True,
                        "metricsEnabled": True,
                    },
                    "serviceConfigsProfiles": [
                        {
                            "configs": [
                                {
                                    "component": "TestComp1",
                                    "files": [
                                        {
                                            "fileName": "TestFile1",
                                            "values": {"Test.config.1": "1", "Test.config.2": "2"},
                                        },
                                        {
                                            "fileName": "TestFile2",
                                            "values": {"Test.config.3": "3", "Test.config.4": "4"},
                                        },
                                    ],
                                },
                                {
                                    "component": "TestComp2",
                                    "files": [
                                        {"content": "TestContent", "fileName": "TestFile3", "path": "TestPath"},
                                        {
                                            "fileName": "TestFile4",
                                            "values": {"Test.config.7": "7", "Test.config.8": "8"},
                                        },
                                    ],
                                },
                            ],
                            "serviceName": "TestService1",
                        },
                        {
                            "configs": [
                                {
                                    "component": "TestComp3",
                                    "files": [{"fileName": "TestFile5", "values": {"Test.config.9": "9"}}],
                                }
                            ],
                            "serviceName": "TestService2",
                        },
                    ],
                    "sshProfile": {"count": 2},
                }
            }
        },
    ).result()
    print(response)


# x-ms-original-file: specification/hdinsight/resource-manager/Microsoft.HDInsight/HDInsightOnAks/preview/2023-11-01-preview/examples/PatchCluster.json
if __name__ == "__main__":
    main()
