# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import Any, Callable, Dict, IO, List, Optional, Type, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import _model_base, models as _models
from .._model_base import SdkJSONEncoder, _deserialize
from .._serialization import Serializer
from .._vendor import FaceClientMixinABC, FaceSessionClientMixinABC, prepare_multipart_form_data

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
_Unset: Any = object()
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_face_detect_from_url_request(
    *,
    detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
    recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
    return_face_id: Optional[bool] = None,
    return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
    return_face_landmarks: Optional[bool] = None,
    return_recognition_model: Optional[bool] = None,
    face_id_time_to_live: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detect"

    # Construct parameters
    if detection_model is not None:
        _params["detectionModel"] = _SERIALIZER.query("detection_model", detection_model, "str")
    if recognition_model is not None:
        _params["recognitionModel"] = _SERIALIZER.query("recognition_model", recognition_model, "str")
    if return_face_id is not None:
        _params["returnFaceId"] = _SERIALIZER.query("return_face_id", return_face_id, "bool")
    if return_face_attributes is not None:
        _params["returnFaceAttributes"] = _SERIALIZER.query(
            "return_face_attributes", return_face_attributes, "[str]", div=","
        )
    if return_face_landmarks is not None:
        _params["returnFaceLandmarks"] = _SERIALIZER.query("return_face_landmarks", return_face_landmarks, "bool")
    if return_recognition_model is not None:
        _params["returnRecognitionModel"] = _SERIALIZER.query(
            "return_recognition_model", return_recognition_model, "bool"
        )
    if face_id_time_to_live is not None:
        _params["faceIdTimeToLive"] = _SERIALIZER.query("face_id_time_to_live", face_id_time_to_live, "int")

    # Construct headers
    if content_type is not None:
        _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_face_detect_request(
    *,
    detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
    recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
    return_face_id: Optional[bool] = None,
    return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
    return_face_landmarks: Optional[bool] = None,
    return_recognition_model: Optional[bool] = None,
    face_id_time_to_live: Optional[int] = None,
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    content_type: str = kwargs.pop("content_type")
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detect"

    # Construct parameters
    if detection_model is not None:
        _params["detectionModel"] = _SERIALIZER.query("detection_model", detection_model, "str")
    if recognition_model is not None:
        _params["recognitionModel"] = _SERIALIZER.query("recognition_model", recognition_model, "str")
    if return_face_id is not None:
        _params["returnFaceId"] = _SERIALIZER.query("return_face_id", return_face_id, "bool")
    if return_face_attributes is not None:
        _params["returnFaceAttributes"] = _SERIALIZER.query(
            "return_face_attributes", return_face_attributes, "[str]", div=","
        )
    if return_face_landmarks is not None:
        _params["returnFaceLandmarks"] = _SERIALIZER.query("return_face_landmarks", return_face_landmarks, "bool")
    if return_recognition_model is not None:
        _params["returnRecognitionModel"] = _SERIALIZER.query(
            "return_recognition_model", return_recognition_model, "bool"
        )
    if face_id_time_to_live is not None:
        _params["faceIdTimeToLive"] = _SERIALIZER.query("face_id_time_to_live", face_id_time_to_live, "int")

    # Construct headers
    _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, params=_params, headers=_headers, **kwargs)


def build_face_find_similar_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/findsimilars"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_verify_face_to_face_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/verify"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_group_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/group"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_session_create_liveness_session_request(**kwargs: Any) -> HttpRequest:  # pylint: disable=name-too-long
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLiveness/singleModal/sessions"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_session_delete_liveness_session_request(  # pylint: disable=name-too-long
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLiveness/singleModal/sessions/{sessionId}"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_face_session_get_liveness_session_result_request(  # pylint: disable=name-too-long
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLiveness/singleModal/sessions/{sessionId}"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_face_session_get_liveness_sessions_request(  # pylint: disable=name-too-long
    *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLiveness/singleModal/sessions"

    # Construct parameters
    if start is not None:
        _params["start"] = _SERIALIZER.query("start", start, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_face_session_get_liveness_session_audit_entries_request(  # pylint: disable=name-too-long
    session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLiveness/singleModal/sessions/{sessionId}/audit"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if start is not None:
        _params["start"] = _SERIALIZER.query("start", start, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_face_session_create_liveness_with_verify_session_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_session_create_liveness_with_verify_session_with_verify_image_request(  # pylint: disable=name-too-long
    **kwargs: Any,
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_face_session_delete_liveness_with_verify_session_request(  # pylint: disable=name-too-long
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions/{sessionId}"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_face_session_get_liveness_with_verify_session_result_request(  # pylint: disable=name-too-long
    session_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions/{sessionId}"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_face_session_get_liveness_with_verify_sessions_request(  # pylint: disable=name-too-long
    *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions"

    # Construct parameters
    if start is not None:
        _params["start"] = _SERIALIZER.query("start", start, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


def build_face_session_get_liveness_with_verify_session_audit_entries_request(  # pylint: disable=name-too-long
    session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/detectLivenessWithVerify/singleModal/sessions/{sessionId}/audit"
    path_format_arguments = {
        "sessionId": _SERIALIZER.url("session_id", session_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct parameters
    if start is not None:
        _params["start"] = _SERIALIZER.query("start", start, "str")
    if top is not None:
        _params["top"] = _SERIALIZER.query("top", top, "int")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, params=_params, headers=_headers, **kwargs)


class FaceClientOperationsMixin(FaceClientMixinABC):

    @overload
    def _detect_from_url(
        self,
        body: JSON,
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    def _detect_from_url(
        self,
        *,
        url: str,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.FaceDetectionResult]: ...
    @overload
    def _detect_from_url(
        self,
        body: IO[bytes],
        *,
        content_type: str = "application/json",
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.FaceDetectionResult]: ...

    @distributed_trace
    def _detect_from_url(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        url: str = _Unset,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.FaceDetectionResult]:
        # pylint: disable=line-too-long
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        ..

           [!IMPORTANT]
           To mitigate potential misuse that can subject people to stereotyping, discrimination, or
        unfair denial of services, we are retiring Face API attributes that predict emotion, gender,
        age, smile, facial hair, hair, and makeup. Read more about this decision
        https://azure.microsoft.com/blog/responsible-ai-investments-and-safeguards-for-facial-recognition/.


        *


        * No image will be stored. Only the extracted face feature(s) will be stored on server. The
        faceId is an identifier of the face feature and will be used in "Identify", "Verify", and "Find
        Similar". The stored face features will expire and be deleted at the time specified by
        faceIdTimeToLive after the original detection call.
        * Optional parameters include faceId, landmarks, and attributes. Attributes include headPose,
        glasses, occlusion, accessories, blur, exposure, noise, mask, and qualityForRecognition. Some
        of the results returned for specific attributes may not be highly accurate.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Up to 100 faces can be returned for an image. Faces are ranked by face rectangle size from
        large to small.
        * For optimal results when querying "Identify", "Verify", and "Find Similar" ('returnFaceId' is
        true), please use faces that are: frontal, clear, and with a minimum size of 200x200 pixels
        (100 pixels between eyes).
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

          * 'detection_02': Face attributes and landmarks are disabled if you choose this detection
        model.
          * 'detection_03': Face attributes (mask, blur, and headPose) and landmarks are supported if
        you choose this detection model.

        * Different 'recognitionModel' values are provided. If follow-up operations like "Verify",
        "Identify", "Find Similar" are needed, please specify the recognition model with
        'recognitionModel' parameter. The default value for 'recognitionModel' is 'recognition_01', if
        latest model needed, please explicitly specify the model you need in this parameter. Once
        specified, the detected faceIds will be associated with the specified recognition model. More
        details, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-recognition-model.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword url: URL of input image. Required.
        :paramtype url: str
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "url": "str"  # URL of input image. Required.
                }

                # response body for status code(s): 200
                response == [
                    {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "faceAttributes": {
                            "accessories": [
                                {
                                    "confidence": 0.0,  # Confidence level of the
                                      accessory type. Range between [0,1]. Required.
                                    "type": "str"  # Type of the accessory.
                                      Required. Known values are: "headwear", "glasses", and "mask".
                                }
                            ],
                            "age": 0.0,  # Optional. Age in years.
                            "blur": {
                                "blurLevel": "str",  # An enum value indicating level
                                  of blurriness. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of
                                  blurriness ranging from 0 to 1. Required.
                            },
                            "exposure": {
                                "exposureLevel": "str",  # An enum value indicating
                                  level of exposure. Required. Known values are: "underExposure",
                                  "goodExposure", and "overExposure".
                                "value": 0.0  # A number indicating level of exposure
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. Required.
                            },
                            "facialHair": {
                                "beard": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "moustache": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "sideburns": 0.0  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                            },
                            "glasses": "str",  # Optional. Glasses type if any of the
                              face. Known values are: "noGlasses", "readingGlasses", "sunglasses", and
                              "swimmingGoggles".
                            "hair": {
                                "bald": 0.0,  # A number describing confidence level
                                  of whether the person is bald. Required.
                                "hairColor": [
                                    {
                                        "color": "str",  # Name of the hair
                                          color. Required. Known values are: "unknown", "white",
                                          "gray", "blond", "brown", "red", "black", and "other".
                                        "confidence": 0.0  # Confidence level
                                          of the color. Range between [0,1]. Required.
                                    }
                                ],
                                "invisible": bool  # A boolean value describing
                                  whether the hair is visible in the image. Required.
                            },
                            "headPose": {
                                "pitch": 0.0,  # Value of angles. Required.
                                "roll": 0.0,  # Value of angles. Required.
                                "yaw": 0.0  # Value of angles. Required.
                            },
                            "mask": {
                                "noseAndMouthCovered": bool,  # A boolean value
                                  indicating whether nose and mouth are covered. Required.
                                "type": "str"  # Type of the mask. Required. Known
                                  values are: "faceMask", "noMask", "otherMaskOrOcclusion", and
                                  "uncertain".
                            },
                            "noise": {
                                "noiseLevel": "str",  # An enum value indicating
                                  level of noise. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of noise
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise
                                  level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise
                                  level. Required.
                            },
                            "occlusion": {
                                "eyeOccluded": bool,  # A boolean value indicating
                                  whether eyes are occluded. Required.
                                "foreheadOccluded": bool,  # A boolean value
                                  indicating whether forehead is occluded. Required.
                                "mouthOccluded": bool  # A boolean value indicating
                                  whether the mouth is occluded. Required.
                            },
                            "qualityForRecognition": "str",  # Optional. Properties
                              describing the overall image quality regarding whether the image being
                              used in the detection is of sufficient quality to attempt face
                              recognition on. Known values are: "low", "medium", and "high".
                            "smile": 0.0  # Optional. Smile intensity, a number between
                              [0,1].
                        },
                        "faceId": "str",  # Optional. Unique faceId of the detected face,
                          created by detection API and it will expire 24 hours after the detection
                          call. To return this, it requires 'returnFaceId' parameter to be true.
                        "faceLandmarks": {
                            "eyeLeftBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            }
                        },
                        "recognitionModel": "str"  # Optional. The 'recognitionModel'
                          associated with this faceId. This is only returned when
                          'returnRecognitionModel' is explicitly set as true. Known values are:
                          "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if url is _Unset:
                raise TypeError("missing required argument: url")
            body = {"url": url}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_detect_from_url_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def _detect(
        self,
        image_content: bytes,
        *,
        detection_model: Optional[Union[str, _models.FaceDetectionModel]] = None,
        recognition_model: Optional[Union[str, _models.FaceRecognitionModel]] = None,
        return_face_id: Optional[bool] = None,
        return_face_attributes: Optional[List[Union[str, _models.FaceAttributeType]]] = None,
        return_face_landmarks: Optional[bool] = None,
        return_recognition_model: Optional[bool] = None,
        face_id_time_to_live: Optional[int] = None,
        **kwargs: Any,
    ) -> List[_models.FaceDetectionResult]:
        # pylint: disable=line-too-long
        """Detect human faces in an image, return face rectangles, and optionally with faceIds, landmarks,
        and attributes.

        ..

           [!IMPORTANT]
           To mitigate potential misuse that can subject people to stereotyping, discrimination, or
        unfair denial of services, we are retiring Face API attributes that predict emotion, gender,
        age, smile, facial hair, hair, and makeup. Read more about this decision
        https://azure.microsoft.com/blog/responsible-ai-investments-and-safeguards-for-facial-recognition/.


        *


        * No image will be stored. Only the extracted face feature(s) will be stored on server. The
        faceId is an identifier of the face feature and will be used in "Identify", "Verify", and "Find
        Similar". The stored face features will expire and be deleted at the time specified by
        faceIdTimeToLive after the original detection call.
        * Optional parameters include faceId, landmarks, and attributes. Attributes include headPose,
        glasses, occlusion, accessories, blur, exposure, noise, mask, and qualityForRecognition. Some
        of the results returned for specific attributes may not be highly accurate.
        * JPEG, PNG, GIF (the first frame), and BMP format are supported. The allowed image file size
        is from 1KB to 6MB.
        * The minimum detectable face size is 36x36 pixels in an image no larger than 1920x1080 pixels.
        Images with dimensions higher than 1920x1080 pixels will need a proportionally larger minimum
        face size.
        * Up to 100 faces can be returned for an image. Faces are ranked by face rectangle size from
        large to small.
        * For optimal results when querying "Identify", "Verify", and "Find Similar" ('returnFaceId' is
        true), please use faces that are: frontal, clear, and with a minimum size of 200x200 pixels
        (100 pixels between eyes).
        * Different 'detectionModel' values can be provided. To use and compare different detection
        models, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-detection-model

          * 'detection_02': Face attributes and landmarks are disabled if you choose this detection
        model.
          * 'detection_03': Face attributes (mask, blur, and headPose) and landmarks are supported if
        you choose this detection model.

        * Different 'recognitionModel' values are provided. If follow-up operations like "Verify",
        "Identify", "Find Similar" are needed, please specify the recognition model with
        'recognitionModel' parameter. The default value for 'recognitionModel' is 'recognition_01', if
        latest model needed, please explicitly specify the model you need in this parameter. Once
        specified, the detected faceIds will be associated with the specified recognition model. More
        details, please refer to
        https://learn.microsoft.com/azure/ai-services/computer-vision/how-to/specify-recognition-model.

        :param image_content: The input image binary. Required.
        :type image_content: bytes
        :keyword detection_model: The 'detectionModel' associated with the detected faceIds. Supported
         'detectionModel' values include 'detection_01', 'detection_02' and 'detection_03'. The default
         value is 'detection_01'. Known values are: "detection_01", "detection_02", and "detection_03".
         Default value is None.
        :paramtype detection_model: str or ~azure.ai.vision.face.models.FaceDetectionModel
        :keyword recognition_model: The 'recognitionModel' associated with the detected faceIds.
         Supported 'recognitionModel' values include 'recognition_01', 'recognition_02',
         'recognition_03' or 'recognition_04'. The default value is 'recognition_01'. 'recognition_04'
         is recommended since its accuracy is improved on faces wearing masks compared with
         'recognition_03', and its overall accuracy is improved compared with 'recognition_01' and
         'recognition_02'. Known values are: "recognition_01", "recognition_02", "recognition_03", and
         "recognition_04". Default value is None.
        :paramtype recognition_model: str or ~azure.ai.vision.face.models.FaceRecognitionModel
        :keyword return_face_id: Return faceIds of the detected faces or not. The default value is
         true. Default value is None.
        :paramtype return_face_id: bool
        :keyword return_face_attributes: Analyze and return the one or more specified face attributes
         in the comma-separated string like 'returnFaceAttributes=headPose,glasses'. Face attribute
         analysis has additional computational and time cost. Default value is None.
        :paramtype return_face_attributes: list[str or ~azure.ai.vision.face.models.FaceAttributeType]
        :keyword return_face_landmarks: Return face landmarks of the detected faces or not. The default
         value is false. Default value is None.
        :paramtype return_face_landmarks: bool
        :keyword return_recognition_model: Return 'recognitionModel' or not. The default value is
         false. This is only applicable when returnFaceId = true. Default value is None.
        :paramtype return_recognition_model: bool
        :keyword face_id_time_to_live: The number of seconds for the face ID being cached. Supported
         range from 60 seconds up to 86400 seconds. The default value is 86400 (24 hours). Default value
         is None.
        :paramtype face_id_time_to_live: int
        :return: list of FaceDetectionResult
        :rtype: list[~azure.ai.vision.face.models.FaceDetectionResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "faceAttributes": {
                            "accessories": [
                                {
                                    "confidence": 0.0,  # Confidence level of the
                                      accessory type. Range between [0,1]. Required.
                                    "type": "str"  # Type of the accessory.
                                      Required. Known values are: "headwear", "glasses", and "mask".
                                }
                            ],
                            "age": 0.0,  # Optional. Age in years.
                            "blur": {
                                "blurLevel": "str",  # An enum value indicating level
                                  of blurriness. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of
                                  blurriness ranging from 0 to 1. Required.
                            },
                            "exposure": {
                                "exposureLevel": "str",  # An enum value indicating
                                  level of exposure. Required. Known values are: "underExposure",
                                  "goodExposure", and "overExposure".
                                "value": 0.0  # A number indicating level of exposure
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. Required.
                            },
                            "facialHair": {
                                "beard": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "moustache": 0.0,  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                                "sideburns": 0.0  # A number ranging from 0 to 1
                                  indicating a level of confidence associated with a property.
                                  Required.
                            },
                            "glasses": "str",  # Optional. Glasses type if any of the
                              face. Known values are: "noGlasses", "readingGlasses", "sunglasses", and
                              "swimmingGoggles".
                            "hair": {
                                "bald": 0.0,  # A number describing confidence level
                                  of whether the person is bald. Required.
                                "hairColor": [
                                    {
                                        "color": "str",  # Name of the hair
                                          color. Required. Known values are: "unknown", "white",
                                          "gray", "blond", "brown", "red", "black", and "other".
                                        "confidence": 0.0  # Confidence level
                                          of the color. Range between [0,1]. Required.
                                    }
                                ],
                                "invisible": bool  # A boolean value describing
                                  whether the hair is visible in the image. Required.
                            },
                            "headPose": {
                                "pitch": 0.0,  # Value of angles. Required.
                                "roll": 0.0,  # Value of angles. Required.
                                "yaw": 0.0  # Value of angles. Required.
                            },
                            "mask": {
                                "noseAndMouthCovered": bool,  # A boolean value
                                  indicating whether nose and mouth are covered. Required.
                                "type": "str"  # Type of the mask. Required. Known
                                  values are: "faceMask", "noMask", "otherMaskOrOcclusion", and
                                  "uncertain".
                            },
                            "noise": {
                                "noiseLevel": "str",  # An enum value indicating
                                  level of noise. Required. Known values are: "low", "medium", and
                                  "high".
                                "value": 0.0  # A number indicating level of noise
                                  level ranging from 0 to 1. [0, 0.25) is under exposure. [0.25, 0.75)
                                  is good exposure. [0.75, 1] is over exposure. [0, 0.3) is low noise
                                  level. [0.3, 0.7) is medium noise level. [0.7, 1] is high noise
                                  level. Required.
                            },
                            "occlusion": {
                                "eyeOccluded": bool,  # A boolean value indicating
                                  whether eyes are occluded. Required.
                                "foreheadOccluded": bool,  # A boolean value
                                  indicating whether forehead is occluded. Required.
                                "mouthOccluded": bool  # A boolean value indicating
                                  whether the mouth is occluded. Required.
                            },
                            "qualityForRecognition": "str",  # Optional. Properties
                              describing the overall image quality regarding whether the image being
                              used in the detection is of sufficient quality to attempt face
                              recognition on. Known values are: "low", "medium", and "high".
                            "smile": 0.0  # Optional. Smile intensity, a number between
                              [0,1].
                        },
                        "faceId": "str",  # Optional. Unique faceId of the detected face,
                          created by detection API and it will expire 24 hours after the detection
                          call. To return this, it requires 'returnFaceId' parameter to be true.
                        "faceLandmarks": {
                            "eyeLeftBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeLeftTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyeRightTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowLeftOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightInner": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "eyebrowRightOuter": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "mouthRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseLeftAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarOutTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRightAlarTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseRootRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "noseTip": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilLeft": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "pupilRight": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "underLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipBottom": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            },
                            "upperLipTop": {
                                "x": 0.0,  # The horizontal component, in pixels.
                                  Required.
                                "y": 0.0  # The vertical component, in pixels.
                                  Required.
                            }
                        },
                        "recognitionModel": "str"  # Optional. The 'recognitionModel'
                          associated with this faceId. This is only returned when
                          'returnRecognitionModel' is explicitly set as true. Known values are:
                          "recognition_01", "recognition_02", "recognition_03", and "recognition_04".
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("content-type", "application/octet-stream"))
        cls: ClsType[List[_models.FaceDetectionResult]] = kwargs.pop("cls", None)

        _content = image_content

        _request = build_face_detect_request(
            detection_model=detection_model,
            recognition_model=recognition_model,
            return_face_id=return_face_id,
            return_face_attributes=return_face_attributes,
            return_face_landmarks=return_face_landmarks,
            return_recognition_model=return_recognition_model,
            face_id_time_to_live=face_id_time_to_live,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceDetectionResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def find_similar(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceIds": [
                        "str"  # An array of candidate faceIds. All of them are created by
                          "Detect" and the faceIds will expire 24 hours after the detection call. The
                          number of faceIds is limited to 1000. Required.
                    ],
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    def find_similar(
        self,
        *,
        face_id: str,
        face_ids: List[str],
        content_type: str = "application/json",
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any,
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @overload
    def find_similar(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """

    @distributed_trace
    def find_similar(
        self,
        body: Union[JSON, IO[bytes]] = _Unset,
        *,
        face_id: str = _Unset,
        face_ids: List[str] = _Unset,
        max_num_of_candidates_returned: Optional[int] = None,
        mode: Optional[Union[str, _models.FindSimilarMatchMode]] = None,
        **kwargs: Any,
    ) -> List[_models.FaceFindSimilarResult]:
        # pylint: disable=line-too-long
        """Given query face's faceId, to search the similar-looking faces from a faceId array. A faceId
        array contains the faces created by Detect.

        Depending on the input the returned similar faces list contains faceIds or persistedFaceIds
        ranked by similarity.

        Find similar has two working modes, "matchPerson" and "matchFace". "matchPerson" is the default
        mode that it tries to find faces of the same person as possible by using internal same-person
        thresholds. It is useful to find a known person's other photos. Note that an empty list will be
        returned if no faces pass the internal thresholds. "matchFace" mode ignores same-person
        thresholds and returns ranked similar faces anyway, even the similarity is low. It can be used
        in the cases like searching celebrity-looking faces.

        The 'recognitionModel' associated with the query faceId should be the same as the
        'recognitionModel' used by the target faceId array.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id: faceId of the query face. User needs to call "Detect" first to get a valid
         faceId. Note that this faceId is not persisted and will expire 24 hours after the detection
         call. Required.
        :paramtype face_id: str
        :keyword face_ids: An array of candidate faceIds. All of them are created by "Detect" and the
         faceIds will expire 24 hours after the detection call. The number of faceIds is limited to
         1000. Required.
        :paramtype face_ids: list[str]
        :keyword max_num_of_candidates_returned: The number of top similar faces returned. The valid
         range is [1, 1000]. Default value is 20. Default value is None.
        :paramtype max_num_of_candidates_returned: int
        :keyword mode: Similar face searching mode. It can be 'matchPerson' or 'matchFace'. Default
         value is 'matchPerson'. Known values are: "matchPerson" and "matchFace". Default value is None.
        :paramtype mode: str or ~azure.ai.vision.face.models.FindSimilarMatchMode
        :return: list of FaceFindSimilarResult
        :rtype: list[~azure.ai.vision.face.models.FaceFindSimilarResult]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId": "str",  # faceId of the query face. User needs to call "Detect"
                      first to get a valid faceId. Note that this faceId is not persisted and will
                      expire 24 hours after the detection call. Required.
                    "faceIds": [
                        "str"  # An array of candidate faceIds. All of them are created by
                          "Detect" and the faceIds will expire 24 hours after the detection call. The
                          number of faceIds is limited to 1000. Required.
                    ],
                    "maxNumOfCandidatesReturned": 0,  # Optional. The number of top similar faces
                      returned. The valid range is [1, 1000]. Default value is 20.
                    "mode": "str"  # Optional. Similar face searching mode. It can be
                      'matchPerson' or 'matchFace'. Default value is 'matchPerson'. Known values are:
                      "matchPerson" and "matchFace".
                }

                # response body for status code(s): 200
                response == [
                    {
                        "confidence": 0.0,  # Confidence value of the candidate. The higher
                          confidence, the more similar. Range between [0,1]. Required.
                        "faceId": "str",  # Optional. faceId of candidate face when find by
                          faceIds. faceId is created by "Detect" and will expire 24 hours after the
                          detection call.
                        "persistedFaceId": "str"  # Optional. persistedFaceId of candidate
                          face when find by faceListId or largeFaceListId. persistedFaceId in face
                          list/large face list is persisted and will not expire.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[List[_models.FaceFindSimilarResult]] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id is _Unset:
                raise TypeError("missing required argument: face_id")
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {
                "faceid": face_id,
                "faceids": face_ids,
                "maxnumofcandidatesreturned": max_num_of_candidates_returned,
                "mode": mode,
            }
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_find_similar_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.FaceFindSimilarResult], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def verify_face_to_face(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId1": "str",  # The faceId of one face, come from "Detect". Required.
                    "faceId2": "str"  # The faceId of another face, come from "Detect". Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    def verify_face_to_face(
        self, *, face_id1: str, face_id2: str, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @overload
    def verify_face_to_face(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """

    @distributed_trace
    def verify_face_to_face(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_id1: str = _Unset, face_id2: str = _Unset, **kwargs: Any
    ) -> _models.FaceVerificationResult:
        # pylint: disable=line-too-long
        """Verify whether two faces belong to a same person.

        ..

           [!NOTE]

           *


           * Higher face image quality means better identification precision. Please consider
        high-quality faces: frontal, clear, and face size is 200x200 pixels (100 pixels between eyes)
        or bigger.
           * For the scenarios that are sensitive to accuracy please make your own judgment.
           * The 'recognitionModel' associated with the both faces should be the same.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_id1: The faceId of one face, come from "Detect". Required.
        :paramtype face_id1: str
        :keyword face_id2: The faceId of another face, come from "Detect". Required.
        :paramtype face_id2: str
        :return: FaceVerificationResult. The FaceVerificationResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceVerificationResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceId1": "str",  # The faceId of one face, come from "Detect". Required.
                    "faceId2": "str"  # The faceId of another face, come from "Detect". Required.
                }

                # response body for status code(s): 200
                response == {
                    "confidence": 0.0,  # A number indicates the similarity confidence of whether
                      two faces belong to the same person, or whether the face belongs to the person.
                      By default, isIdentical is set to True if similarity confidence is greater than
                      or equal to 0.5. This is useful for advanced users to override 'isIdentical' and
                      fine-tune the result on their own data. Required.
                    "isIdentical": bool  # True if the two faces belong to the same person or the
                      face belongs to the person, otherwise false. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceVerificationResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_id1 is _Unset:
                raise TypeError("missing required argument: face_id1")
            if face_id2 is _Unset:
                raise TypeError("missing required argument: face_id2")
            body = {"faceid1": face_id1, "faceid2": face_id2}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_verify_face_to_face_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceVerificationResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def group(self, body: JSON, *, content_type: str = "application/json", **kwargs: Any) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of candidate faceIds created by "Detect". The maximum
                          is 1000 faces. Required.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @overload
    def group(
        self, *, face_ids: List[str], content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @overload
    def group(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """

    @distributed_trace
    def group(
        self, body: Union[JSON, IO[bytes]] = _Unset, *, face_ids: List[str] = _Unset, **kwargs: Any
    ) -> _models.FaceGroupingResult:
        # pylint: disable=line-too-long
        """Divide candidate faces into groups based on face similarity.

        >
        *


        * The output is one or more disjointed face groups and a messyGroup. A face group contains
        faces that have similar looking, often of the same person. Face groups are ranked by group
        size, i.e. number of faces. Notice that faces belonging to a same person might be split into
        several groups in the result.
        * MessyGroup is a special face group containing faces that cannot find any similar counterpart
        face from original faces. The messyGroup will not appear in the result if all faces found their
        counterparts.
        * Group API needs at least 2 candidate faces and 1000 at most. We suggest to try "Verify Face
        To Face" when you only have 2 candidate faces.
        * The 'recognitionModel' associated with the query faces' faceIds should be the same.

        :param body: Is either a JSON type or a IO[bytes] type. Required.
        :type body: JSON or IO[bytes]
        :keyword face_ids: Array of candidate faceIds created by "Detect". The maximum is 1000 faces.
         Required.
        :paramtype face_ids: list[str]
        :return: FaceGroupingResult. The FaceGroupingResult is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.FaceGroupingResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "faceIds": [
                        "str"  # Array of candidate faceIds created by "Detect". The maximum
                          is 1000 faces. Required.
                    ]
                }

                # response body for status code(s): 200
                response == {
                    "groups": [
                        [
                            "str"  # A partition of the original faces based on face
                              similarity. Groups are ranked by number of faces. Required.
                        ]
                    ],
                    "messyGroup": [
                        "str"  # Face ids array of faces that cannot find any similar faces
                          from original faces. Required.
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.FaceGroupingResult] = kwargs.pop("cls", None)

        if body is _Unset:
            if face_ids is _Unset:
                raise TypeError("missing required argument: face_ids")
            body = {"faceids": face_ids}
            body = {k: v for k, v in body.items() if v is not None}
        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_group_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.FaceGroupingResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore


class FaceSessionClientOperationsMixin(FaceSessionClientMixinABC):

    @overload
    def create_liveness_session(
        self, body: _models.CreateLivenessSessionContent, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @overload
    def create_liveness_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @overload
    def create_liveness_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Required.
        :type body: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """

    @distributed_trace
    def create_liveness_session(
        self, body: Union[_models.CreateLivenessSessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessSessionResult:
        # pylint: disable=line-too-long
        """Create a new detect liveness session.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLiveness/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]
           Client access can be revoked by deleting the session using the Delete Liveness Session
        operation. To retrieve a result, use the Get Liveness Session. To audit the individual requests
        that a client has made to your resource, use the List Liveness Session Audit Entries.

        :param body: Is one of the following types: CreateLivenessSessionContent, JSON, IO[bytes]
         Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent or JSON or IO[bytes]
        :return: CreateLivenessSessionResult. The CreateLivenessSessionResult is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessSessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str"  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessSessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessSessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_liveness_session(  # pylint: disable=inconsistent-return-statements
        self, session_id: str, **kwargs: Any
    ) -> None:
        """Delete all session related information for matching the specified session id.

        ..

           [!NOTE]
           Deleting a session deactivates the Session Auth Token by blocking future API calls made with
        that Auth Token. While this can be used to remove any access for that token, those requests
        will still count towards overall resource rate limits. It's best to leverage TokenTTL to limit
        length of tokens in the case that it is misused.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_liveness_session_result(self, session_id: str, **kwargs: Any) -> _models.LivenessSession:
        # pylint: disable=line-too-long
        """Get session result of detectLiveness/singleModal call.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessSession. The LivenessSession is compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessSession
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this session was
                      created. Required.
                    "id": "str",  # The unique ID to reference this session. Required.
                    "sessionExpired": bool,  # Whether or not the session is expired. Required.
                    "status": "str",  # The current status of the session. Required. Known values
                      are: "NotStarted", "Started", and "ResultAvailable".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "result": {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    },
                    "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime when this
                      session was started by the client.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessSession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessSession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_liveness_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        # pylint: disable=line-too-long
        """Lists sessions for /detectLiveness/SingleModal.

        List sessions from the last sessionId greater than the 'start'.

        The result should be ordered by sessionId in ascending order.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this
                          session was created. Required.
                        "id": "str",  # The unique ID to reference this session. Required.
                        "sessionExpired": bool,  # Whether or not the session is expired.
                          Required.
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime
                          when this session was started by the client.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_liveness_session_audit_entries(
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        # pylint: disable=line-too-long
        """Gets session requests and response body for the session.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _create_liveness_with_verify_session(
        self, body: _models.CreateLivenessSessionContent, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    def _create_liveness_with_verify_session(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    def _create_liveness_with_verify_session(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace
    def _create_liveness_with_verify_session(
        self, body: Union[_models.CreateLivenessSessionContent, JSON, IO[bytes]], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        # pylint: disable=line-too-long
        """Create a new liveness session with verify. Client device submits VerifyImage during the
        /detectLivenessWithVerify/singleModal call.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLivenessWithVerify/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]

           *


           * Client access can be revoked by deleting the session using the Delete Liveness With Verify
        Session operation.
           * To retrieve a result, use the Get Liveness With Verify Session.
           * To audit the individual requests that a client has made to your resource, use the List
        Liveness With Verify Session Audit Entries.


        Alternative Option: Client device submits VerifyImage during the
        /detectLivenessWithVerify/singleModal call.

        ..

           [!NOTE]
           Extra measures should be taken to validate that the client is sending the expected
        VerifyImage.

        :param body: Is one of the following types: CreateLivenessSessionContent, JSON, IO[bytes]
         Required.
        :type body: ~azure.ai.vision.face.models.CreateLivenessSessionContent or JSON or IO[bytes]
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "livenessOperationMode": "str",  # Type of liveness mode the client should
                      follow. Required. Known values are: "Passive" and "PassiveActive".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not to allow
                      client to set their own 'deviceCorrelationId' via the Vision SDK. Default is
                      false, and 'deviceCorrelationId' must be set in this request body.
                    "sendResultsToClient": bool  # Optional. Whether or not to allow a '200 -
                      Success' response body to be sent to the client, which may be undesirable for
                      security reasons. Default is false, clients will receive a '204 - NoContent'
                      empty body response. Regardless of selection, calling Session GetResult will
                      always contain a response body enabling business logic to be implemented.
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str",  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                    "verifyImage": {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "qualityForRecognition": "str"  # Quality of face image for
                          recognition. Required. Known values are: "low", "medium", and "high".
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_face_session_create_liveness_with_verify_session_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=protected-access,name-too-long
        self, body: _models._models.CreateLivenessWithVerifySessionContent, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...
    @overload
    def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: JSON, **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult: ...

    @distributed_trace
    def _create_liveness_with_verify_session_with_verify_image(  # pylint: disable=name-too-long
        self, body: Union[_models._models.CreateLivenessWithVerifySessionContent, JSON], **kwargs: Any
    ) -> _models.CreateLivenessWithVerifySessionResult:
        # pylint: disable=line-too-long
        """Create a new liveness session with verify. Provide the verify image during session creation.

        A session is best for client device scenarios where developers want to authorize a client
        device to perform only a liveness detection without granting full access to their resource.
        Created sessions have a limited life span and only authorize clients to perform the desired
        action before access is expired.

        Permissions includes...
        >
        *


        * Ability to call /detectLivenessWithVerify/singleModal for up to 3 retries.
        * A token lifetime of 10 minutes.

        ..

           [!NOTE]

           *


           * Client access can be revoked by deleting the session using the Delete Liveness With Verify
        Session operation.
           * To retrieve a result, use the Get Liveness With Verify Session.
           * To audit the individual requests that a client has made to your resource, use the List
        Liveness With Verify Session Audit Entries.


        Recommended Option: VerifyImage is provided during session creation.

        :param body: Is either a CreateLivenessWithVerifySessionContent type or a JSON type. Required.
        :type body: ~azure.ai.vision.face.models._models.CreateLivenessWithVerifySessionContent or JSON
        :return: CreateLivenessWithVerifySessionResult. The CreateLivenessWithVerifySessionResult is
         compatible with MutableMapping
        :rtype: ~azure.ai.vision.face.models.CreateLivenessWithVerifySessionResult
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "Parameters": {
                        "livenessOperationMode": "str",  # Type of liveness mode the client
                          should follow. Required. Known values are: "Passive" and "PassiveActive".
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "deviceCorrelationIdSetInClient": bool,  # Optional. Whether or not
                          to allow client to set their own 'deviceCorrelationId' via the Vision SDK.
                          Default is false, and 'deviceCorrelationId' must be set in this request body.
                        "sendResultsToClient": bool  # Optional. Whether or not to allow a
                          '200 - Success' response body to be sent to the client, which may be
                          undesirable for security reasons. Default is false, clients will receive a
                          '204 - NoContent' empty body response. Regardless of selection, calling
                          Session GetResult will always contain a response body enabling business logic
                          to be implemented.
                    },
                    "VerifyImage": filetype
                }

                # response body for status code(s): 200
                response == {
                    "authToken": "str",  # Bearer token to provide authentication for the Vision
                      SDK running on a client application. This Bearer token has limited permissions to
                      perform only the required action and expires after the TTL time. It is also
                      auditable. Required.
                    "sessionId": "str",  # The unique session ID of the created session. It will
                      expire 48 hours after it was created or may be deleted sooner using the
                      corresponding Session DELETE operation. Required.
                    "verifyImage": {
                        "faceRectangle": {
                            "height": 0,  # The height of the rectangle, in pixels.
                              Required.
                            "left": 0,  # The distance from the left edge if the image to
                              the left edge of the rectangle, in pixels. Required.
                            "top": 0,  # The distance from the top edge if the image to
                              the top edge of the rectangle, in pixels. Required.
                            "width": 0  # The width of the rectangle, in pixels.
                              Required.
                        },
                        "qualityForRecognition": "str"  # Quality of face image for
                          recognition. Required. Known values are: "low", "medium", and "high".
                    }
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.CreateLivenessWithVerifySessionResult] = kwargs.pop("cls", None)

        _body = body.as_dict() if isinstance(body, _model_base.Model) else body
        _file_fields: List[str] = ["VerifyImage"]
        _data_fields: List[str] = ["Parameters"]
        _files, _data = prepare_multipart_form_data(_body, _file_fields, _data_fields)

        _request = build_face_session_create_liveness_with_verify_session_with_verify_image_request(
            files=_files,
            data=_data,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.CreateLivenessWithVerifySessionResult, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def delete_liveness_with_verify_session(  # pylint: disable=inconsistent-return-statements
        self, session_id: str, **kwargs: Any
    ) -> None:
        """Delete all session related information for matching the specified session id.

        ..

           [!NOTE]
           Deleting a session deactivates the Session Auth Token by blocking future API calls made with
        that Auth Token. While this can be used to remove any access for that token, those requests
        will still count towards overall resource rate limits. It's best to leverage TokenTTL to limit
        length of tokens in the case that it is misused.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_face_session_delete_liveness_with_verify_session_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore

    @distributed_trace
    def get_liveness_with_verify_session_result(
        self, session_id: str, **kwargs: Any
    ) -> _models.LivenessWithVerifySession:
        # pylint: disable=line-too-long
        """Get session result of detectLivenessWithVerify/singleModal call.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :return: LivenessWithVerifySession. The LivenessWithVerifySession is compatible with
         MutableMapping
        :rtype: ~azure.ai.vision.face.models.LivenessWithVerifySession
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this session was
                      created. Required.
                    "id": "str",  # The unique ID to reference this session. Required.
                    "sessionExpired": bool,  # Whether or not the session is expired. Required.
                    "status": "str",  # The current status of the session. Required. Known values
                      are: "NotStarted", "Started", and "ResultAvailable".
                    "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session should
                      last for. Range is 60 to 86400 seconds. Default value is 600.
                    "deviceCorrelationId": "str",  # Optional. Unique Guid per each end-user
                      device. This is to provide rate limiting and anti-hammering. If
                      'deviceCorrelationIdSetInClient' is true in this request, this
                      'deviceCorrelationId' must be null.
                    "result": {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    },
                    "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime when this
                      session was started by the client.
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.LivenessWithVerifySession] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_result_request(
            session_id=session_id,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.LivenessWithVerifySession, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_liveness_with_verify_sessions(
        self, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionItem]:
        # pylint: disable=line-too-long
        """Lists sessions for /detectLivenessWithVerify/SingleModal.

        List sessions from the last sessionId greater than the "start".

        The result should be ordered by sessionId in ascending order.

        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionItem
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionItem]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "createdDateTime": "2020-02-20 00:00:00",  # DateTime when this
                          session was created. Required.
                        "id": "str",  # The unique ID to reference this session. Required.
                        "sessionExpired": bool,  # Whether or not the session is expired.
                          Required.
                        "authTokenTimeToLiveInSeconds": 0,  # Optional. Seconds the session
                          should last for. Range is 60 to 86400 seconds. Default value is 600.
                        "deviceCorrelationId": "str",  # Optional. Unique Guid per each
                          end-user device. This is to provide rate limiting and anti-hammering. If
                          'deviceCorrelationIdSetInClient' is true in this request, this
                          'deviceCorrelationId' must be null.
                        "sessionStartDateTime": "2020-02-20 00:00:00"  # Optional. DateTime
                          when this session was started by the client.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionItem]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_sessions_request(
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionItem], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace
    def get_liveness_with_verify_session_audit_entries(  # pylint: disable=name-too-long
        self, session_id: str, *, start: Optional[str] = None, top: Optional[int] = None, **kwargs: Any
    ) -> List[_models.LivenessSessionAuditEntry]:
        # pylint: disable=line-too-long
        """Gets session requests and response body for the session.

        :param session_id: The unique ID to reference this session. Required.
        :type session_id: str
        :keyword start: List resources greater than the "start". It contains no more than 64
         characters. Default is empty. Default value is None.
        :paramtype start: str
        :keyword top: The number of items to list, ranging in [1, 1000]. Default is 1000. Default value
         is None.
        :paramtype top: int
        :return: list of LivenessSessionAuditEntry
        :rtype: list[~azure.ai.vision.face.models.LivenessSessionAuditEntry]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == [
                    {
                        "clientRequestId": "str",  # The unique clientRequestId that is sent
                          by the client in the 'client-request-id' header. Required.
                        "digest": "str",  # The server calculated digest for this request. If
                          the client reported digest differs from the server calculated digest, then
                          the message integrity between the client and service has been compromised and
                          the result should not be trusted. For more information, see how to guides on
                          how to leverage this value to secure your end-to-end solution. Required.
                        "id": 0,  # The unique id to refer to this audit request. Use this id
                          with the 'start' query parameter to continue on to the next page of audit
                          results. Required.
                        "receivedDateTime": "2020-02-20 00:00:00",  # The UTC DateTime that
                          the request was received. Required.
                        "request": {
                            "contentType": "str",  # The content type of the request.
                              Required.
                            "method": "str",  # The HTTP method of the request (i.e.,
                              GET, POST, DELETE). Required.
                            "url": "str",  # The relative URL and query of the liveness
                              request. Required.
                            "contentLength": 0,  # Optional. The length of the request
                              body in bytes.
                            "userAgent": "str"  # Optional. The user agent used to submit
                              the request.
                        },
                        "requestId": "str",  # The unique requestId that is returned by the
                          service to the client in the 'apim-request-id' header. Required.
                        "response": {
                            "body": {
                                "livenessDecision": "str",  # Optional. The liveness
                                  classification for the target face. Known values are: "uncertain",
                                  "realface", and "spoofface".
                                "modelVersionUsed": "str",  # Optional. The model
                                  version used for liveness classification. Known values are:
                                  "2020-02-15-preview.01", "2021-11-12-preview.03",
                                  "2022-10-15-preview.04", and "2023-03-02-preview.05".
                                "target": {
                                    "faceRectangle": {
                                        "height": 0,  # The height of the
                                          rectangle, in pixels. Required.
                                        "left": 0,  # The distance from the
                                          left edge if the image to the left edge of the rectangle, in
                                          pixels. Required.
                                        "top": 0,  # The distance from the
                                          top edge if the image to the top edge of the rectangle, in
                                          pixels. Required.
                                        "width": 0  # The width of the
                                          rectangle, in pixels. Required.
                                    },
                                    "fileName": "str",  # The file name which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required.
                                    "imageType": "str",  # The image type which
                                      contains the face rectangle where the liveness classification was
                                      made on. Required. Known values are: "Color", "Infrared", and
                                      "Depth".
                                    "timeOffsetWithinFile": 0  # The time offset
                                      within the file of the frame which contains the face rectangle
                                      where the liveness classification was made on. Required.
                                },
                                "verifyResult": {
                                    "isIdentical": bool,  # Whether the target
                                      liveness face and comparison image face match. Required.
                                    "matchConfidence": 0.0,  # The target face
                                      liveness face and comparison image face verification confidence.
                                      Required.
                                    "verifyImage": {
                                        "faceRectangle": {
                                            "height": 0,  # The height of
                                              the rectangle, in pixels. Required.
                                            "left": 0,  # The distance
                                              from the left edge if the image to the left edge of the
                                              rectangle, in pixels. Required.
                                            "top": 0,  # The distance
                                              from the top edge if the image to the top edge of the
                                              rectangle, in pixels. Required.
                                            "width": 0  # The width of
                                              the rectangle, in pixels. Required.
                                        },
                                        "qualityForRecognition": "str"  #
                                          Quality of face image for recognition. Required. Known values
                                          are: "low", "medium", and "high".
                                    }
                                }
                            },
                            "latencyInMilliseconds": 0,  # The server measured latency
                              for this request in milliseconds. Required.
                            "statusCode": 0  # The HTTP status code returned to the
                              client. Required.
                        },
                        "sessionId": "str"  # The unique sessionId of the created session. It
                          will expire 48 hours after it was created or may be deleted sooner using the
                          corresponding session DELETE operation. Required.
                    }
                ]
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.LivenessSessionAuditEntry]] = kwargs.pop("cls", None)

        _request = build_face_session_get_liveness_with_verify_session_audit_entries_request(
            session_id=session_id,
            start=start,
            top=top,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                response.read()  # Load the body in memory and close the socket
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.FaceErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(List[_models.LivenessSessionAuditEntry], response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
