# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementVirtualMachineScaleSetExtensionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_create_or_update(self, resource_group):
        response = self.client.virtual_machine_scale_set_extensions.begin_create_or_update(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            vmss_extension_name="str",
            extension_parameters={
                "autoUpgradeMinorVersion": bool,
                "forceUpdateTag": "str",
                "id": "str",
                "name": "str",
                "protectedSettings": {},
                "provisioningState": "str",
                "publisher": "str",
                "settings": {},
                "type": "str",
                "typeHandlerVersion": "str",
            },
            api_version="2017-03-30",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_begin_delete(self, resource_group):
        response = self.client.virtual_machine_scale_set_extensions.begin_delete(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            vmss_extension_name="str",
            api_version="2017-03-30",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_get(self, resource_group):
        response = self.client.virtual_machine_scale_set_extensions.get(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            vmss_extension_name="str",
            api_version="2017-03-30",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_list(self, resource_group):
        response = self.client.virtual_machine_scale_set_extensions.list(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            api_version="2017-03-30",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
