# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, IO, Union

from azure.identity import DefaultAzureCredential

from azure.mgmt.compute import ComputeManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-compute
# USAGE
    python dedicated_host_group_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ComputeManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="{subscription-id}",
    )

    response = client.dedicated_host_groups.update(
        resource_group_name="rgcompute",
        host_group_name="aaaa",
        parameters={
            "properties": {
                "instanceView": {
                    "hosts": [
                        {
                            "availableCapacity": {"allocatableVMs": [{"count": 26, "vmSize": "aaaaaaaaaaaaaaaaaaaa"}]},
                            "statuses": [
                                {
                                    "code": "aaaaaaaaaaaaaaaaaaaaaaa",
                                    "displayStatus": "aaaaaa",
                                    "level": "Info",
                                    "message": "a",
                                    "time": "2021-11-30T12:58:26.522Z",
                                }
                            ],
                        }
                    ]
                },
                "platformFaultDomainCount": 3,
                "supportAutomaticPlacement": True,
            },
            "tags": {"key9921": "aaaaaaaaaa"},
            "zones": ["aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"],
        },
    )
    print(response)


# x-ms-original-file: specification/compute/resource-manager/Microsoft.Compute/ComputeRP/stable/2024-03-01/examples/dedicatedHostExamples/DedicatedHostGroup_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
