# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import AzureStackHCIClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    GalleryImagesOperations,
    GuestAgentOperations,
    GuestAgentsOperations,
    HybridIdentityMetadataOperations,
    LogicalNetworksOperations,
    MarketplaceGalleryImagesOperations,
    NetworkInterfacesOperations,
    Operations,
    StorageContainersOperations,
    VirtualHardDisksOperations,
    VirtualMachineInstancesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class AzureStackHCIClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Azure Stack HCI management service.

    :ivar gallery_images: GalleryImagesOperations operations
    :vartype gallery_images: azure.mgmt.azurestackhci.operations.GalleryImagesOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.azurestackhci.operations.Operations
    :ivar logical_networks: LogicalNetworksOperations operations
    :vartype logical_networks: azure.mgmt.azurestackhci.operations.LogicalNetworksOperations
    :ivar marketplace_gallery_images: MarketplaceGalleryImagesOperations operations
    :vartype marketplace_gallery_images:
     azure.mgmt.azurestackhci.operations.MarketplaceGalleryImagesOperations
    :ivar network_interfaces: NetworkInterfacesOperations operations
    :vartype network_interfaces: azure.mgmt.azurestackhci.operations.NetworkInterfacesOperations
    :ivar storage_containers: StorageContainersOperations operations
    :vartype storage_containers: azure.mgmt.azurestackhci.operations.StorageContainersOperations
    :ivar virtual_hard_disks: VirtualHardDisksOperations operations
    :vartype virtual_hard_disks: azure.mgmt.azurestackhci.operations.VirtualHardDisksOperations
    :ivar virtual_machine_instances: VirtualMachineInstancesOperations operations
    :vartype virtual_machine_instances:
     azure.mgmt.azurestackhci.operations.VirtualMachineInstancesOperations
    :ivar hybrid_identity_metadata: HybridIdentityMetadataOperations operations
    :vartype hybrid_identity_metadata:
     azure.mgmt.azurestackhci.operations.HybridIdentityMetadataOperations
    :ivar guest_agent: GuestAgentOperations operations
    :vartype guest_agent: azure.mgmt.azurestackhci.operations.GuestAgentOperations
    :ivar guest_agents: GuestAgentsOperations operations
    :vartype guest_agents: azure.mgmt.azurestackhci.operations.GuestAgentsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2023-09-01-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = AzureStackHCIClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.gallery_images = GalleryImagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.logical_networks = LogicalNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.marketplace_gallery_images = MarketplaceGalleryImagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.network_interfaces = NetworkInterfacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.storage_containers = StorageContainersOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_hard_disks = VirtualHardDisksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.virtual_machine_instances = VirtualMachineInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hybrid_identity_metadata = HybridIdentityMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.guest_agent = GuestAgentOperations(self._client, self._config, self._serialize, self._deserialize)
        self.guest_agents = GuestAgentsOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "AzureStackHCIClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
