/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.tests;

import java.util.Arrays;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.stats.TestType;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.dstats.F;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.matrices.UpperTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.HouseholderR;
import jdplus.toolkit.base.core.stats.likelihood.ConcentratedLikelihood;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class Manova {
    private static final double EPS = 1.0E-9;
    private final double rssq;
    private final int rdf;
    private final Row[] rows;

    public Manova(LinearModel model, int[] groups) {
        HouseholderR qr = new HouseholderR();
        qr.setPrecision(1.0E-9);
        qr.decompose(model.variables());
        ConcentratedLikelihood[] ll = this.nestedModelsEstimation(model.isMeanCorrection(), qr, model.getY(), groups);
        this.rssq = ll[groups.length].ssq();
        this.rdf = ll[groups.length].degreesOfFreedom();
        this.rows = new Row[groups.length];
        for (int i = 0; i < this.rows.length; ++i) {
            int df = ll[i].degreesOfFreedom() - ll[i + 1].degreesOfFreedom();
            double dssq = ll[i].ssq() - ll[i + 1].ssq();
            this.rows[i] = new Row(df, dssq);
        }
    }

    public int getResidualsDegeesOfFreedom() {
        return this.rdf;
    }

    public double getResidualsSsq() {
        return this.rssq;
    }

    public List<Row> getRows() {
        return Arrays.asList(this.rows);
    }

    private ConcentratedLikelihood likelihood(HouseholderR qr, DoubleSeq y, int nvars) {
        int rank = qr.rank(nvars);
        int n = qr.getRowsCount();
        DataBlock res = DataBlock.make(n - rank);
        DataBlock b = DataBlock.make(rank);
        qr.partialLeastSquares(y, b, res);
        double ssqerr = res.ssq();
        FastMatrix u = UpperTriangularMatrix.inverse(qr.r());
        FastMatrix bvar = SymmetricMatrix.UUt(u);
        return ConcentratedLikelihood.builder().ndata(n).ssqErr(ssqerr).residuals((DoubleSeq)res).coefficients((DoubleSeq)b).unscaledCovariance(bvar).build();
    }

    private ConcentratedLikelihood[] nestedModelsEstimation(boolean mean, HouseholderR qr, DoubleSeq y, int[] groups) {
        ConcentratedLikelihood[] ll = new ConcentratedLikelihood[groups.length + 1];
        int n = mean ? 1 : 0;
        ll[0] = this.likelihood(qr, y, n);
        for (int i = 0; i < groups.length; ++i) {
            ll[i + 1] = this.likelihood(qr, y, n += groups[i]);
        }
        return ll;
    }

    public final class Row {
        public final int df;
        public final double ssq;

        Row(int df, double ssq) {
            this.df = df;
            this.ssq = ssq;
        }

        public double mssq() {
            return this.ssq / (double)this.df;
        }

        public StatisticalTest ftest() {
            F f = new F(this.df, Manova.this.rdf);
            double val = this.ssq * (double)Manova.this.rdf / ((double)this.df * Manova.this.rssq);
            return TestsUtility.testOf(val, f, TestType.Upper);
        }
    }
}

