/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.decomposition;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.GeneralEigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.SymmetricEigenSystem;

public class EigenSystem {
    private EigenSystem() {
    }

    public static IEigenSystem create(FastMatrix m, boolean symmetric) {
        if (symmetric) {
            return new SymmetricEigenSystem(m);
        }
        return new GeneralEigenSystem(m);
    }

    public static IEigenSystem create(FastMatrix m) {
        if (EigenSystem.isSymmetric(m)) {
            return new SymmetricEigenSystem(m);
        }
        return new GeneralEigenSystem(m);
    }

    public static boolean isSymmetric(FastMatrix m) {
        if (m.getRowsCount() != m.getColumnsCount()) {
            return false;
        }
        for (int i = 0; i < m.getRowsCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (!(Math.abs(m.get(i, j) - m.get(j, i)) > 1.0E-12)) continue;
                return false;
            }
        }
        return true;
    }

    public static double[] convertToArray(FastMatrix m) {
        return m.toArray();
    }
}

