/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.linearfilters;

import java.util.HashMap;
import java.util.Map;
import jdplus.toolkit.base.api.math.linearfilters.HendersonSpec;
import jdplus.toolkit.base.core.math.linearfilters.AsymmetricFiltersFactory;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IQuasiSymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.ISymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.LinearFilterException;
import jdplus.toolkit.base.core.math.linearfilters.QuasiSymmetricFiltering;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import lombok.Generated;

public final class HendersonFilters {
    private static final Map<Integer, SymmetricFilter> FILTERSTORE = new HashMap<Integer, SymmetricFilter>();

    public static synchronized SymmetricFilter ofLength(int length) {
        SymmetricFilter filter = FILTERSTORE.get(length);
        if (filter != null) {
            return filter;
        }
        if (length % 2 == 0) {
            throw new LinearFilterException("Invalid length for Henderson filter. Should be odd");
        }
        int m = length / 2;
        double[] c = new double[m + 1];
        int n = m + 2;
        double n2 = n * n;
        for (int i = 0; i < m + 1; ++i) {
            double ii = (i - m) * (i - m);
            double up = 315.0 * (n2 - (double)(n * 2) + 1.0 - ii);
            up *= n2 - ii;
            up *= n2 + (double)(n * 2) + 1.0 - ii;
            double down = n * 8;
            down *= n2 - 1.0;
            down *= n2 * 4.0 - 1.0;
            down *= n2 * 4.0 - 9.0;
            c[m - i] = (up *= n2 * 3.0 - 16.0 - ii * 11.0) / (down *= n2 * 4.0 - 25.0);
        }
        filter = SymmetricFilter.ofInternal(c);
        FILTERSTORE.put(length, filter);
        return filter;
    }

    public static IQuasiSymmetricFiltering of(HendersonSpec spec) {
        SymmetricFilter sf = HendersonFilters.ofLength(1 + 2 * spec.getFilterHorizon());
        IFiniteFilter[] rf = AsymmetricFiltersFactory.musgraveFilters(sf, spec.getRightIcRatio());
        IFiniteFilter[] lf = ISymmetricFiltering.mirror(spec.isSymmetric() ? rf : AsymmetricFiltersFactory.musgraveFilters(sf, spec.getLeftIcRatio()));
        return new QuasiSymmetricFiltering(sf, lf, rf);
    }

    @Generated
    private HendersonFilters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

