/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.arima.estimation;

import internal.toolkit.base.core.arima.KalmanFilter;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;

@FunctionalInterface
public interface ResidualsComputer {
    public DoubleSeq residuals(IArimaModel var1, DoubleSeq var2);

    public static ResidualsComputer defaultComputer() {
        return ResidualsComputer.defaultComputer(new KalmanFilter(false));
    }

    public static ResidualsComputer defaultComputer(ArmaFilter filter) {
        return (arma, y) -> {
            int n = y.length();
            int nf = filter.prepare(arma, n);
            DataBlock fres = DataBlock.make(nf);
            filter.apply(y, fres);
            return fres;
        };
    }
}

