% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word.R
\name{word}
\alias{word}
\title{Extract words from a sentence}
\usage{
word(string, start = 1L, end = start, sep = fixed(" "))
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{start, end}{Pair of integer vectors giving range of words (inclusive)
to extract. If negative, counts backwards from the last word.

The default value select the first word.}

\item{sep}{Separator between words. Defaults to single space.}
}
\value{
A character vector with the same length as \code{string}/\code{start}/\code{end}.
}
\description{
Extract words from a sentence
}
\examples{
sentences <- c("Jane saw a cat", "Jane sat down")
word(sentences, 1)
word(sentences, 2)
word(sentences, -1)
word(sentences, 2, -1)

# Also vectorised over start and end
word(sentences[1], 1:3, -1)
word(sentences[1], 1, 1:4)

# Can define words by other separators
str <- 'abc.def..123.4568.999'
word(str, 1, sep = fixed('..'))
word(str, 2, sep = fixed('..'))
}
