## ----echo=FALSE, include=FALSE------------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'functions-chunk')


## ----fun-00a------------------------------------------------------------------------------------------------------------
fun1 <- function(x, y){x * y}


## ----fun-00b------------------------------------------------------------------------------------------------------------
fun1(x = 4, y = 3)


## ----fun-00c, eval=eval_playground--------------------------------------------------------------------------------------
fun1(x = 10, y = 50)
fun1(x = 10, y = 50) * 3


## ----fun-02, eval=eval_playground---------------------------------------------------------------------------------------
FN1 <- function(x) print("prn")
FN1("arg")
FN2 <- function(x){print("prn")
                   return(x)}
FN2("arg")
FN3 <- function(x){return(x)
                   print("prn")}
FN3("arg")
FN4 <- function(x){return()
                   print("prn")}
FN4("arg")
FN5 <- function(x){return(print(x))
                   print("prn")}
FN5("arg")


## ----fun-01-------------------------------------------------------------------------------------------------------------
fn2 <- function(x){x <- 99}
a <- 1
fn2(a)
a


## ----fun-10-------------------------------------------------------------------------------------------------------------
(function(x, y){x * y})(x = 4, y = 3)


## ----fun-11-------------------------------------------------------------------------------------------------------------
(\(x, y){x * y})(x = 4, y = 3)


## ----scope-01-----------------------------------------------------------------------------------------------------------
pi
pi <- "apple pie"
pi
rm(pi)
pi
exists("pi")


## ----scope-02-----------------------------------------------------------------------------------------------------------
my.pie <- "raspberry pie"
my.pie
my.pie <- "apple pie"
my.pie
rm(my.pie)
exists("my.pie")


## ----fun-03-------------------------------------------------------------------------------------------------------------
SEM <- function(x){sqrt(var(x) / length(x))}


## ----fun-04-------------------------------------------------------------------------------------------------------------
a <- c(1, 2, 3, -5)
a.na <- c(a, NA)
SEM(x = a)
SEM(x = a.na)


## ----fun-05-------------------------------------------------------------------------------------------------------------
sem <- function(x, na.rm = FALSE) {
 if (na.rm) {
   x <- na.omit(x)
 }
 sqrt(var(x)/length(x))
}


## ----fun-06-------------------------------------------------------------------------------------------------------------
sem(x = a)
sem(x = a.na)
sem(x = a.na, na.rm = TRUE)


## ----fun-07-------------------------------------------------------------------------------------------------------------
sem


## ----fun-08-------------------------------------------------------------------------------------------------------------
sd


## ----fun-09-------------------------------------------------------------------------------------------------------------
list


## ----oper-01------------------------------------------------------------------------------------------------------------
1 / 2
`/`(1 , 2)
`/`(e1 = 1 , e2 = 2)


## ----oper-02------------------------------------------------------------------------------------------------------------
`/`


## ----oper-EB01----------------------------------------------------------------------------------------------------------
"%-mean%" <- function(e1, e2) {
  e1 - mean(e2)
}


## ----oper-EB02----------------------------------------------------------------------------------------------------------
10:15 %-mean% 1:20


## ----oper-EB03----------------------------------------------------------------------------------------------------------
`%-mean%`


## ----object-classes-00--------------------------------------------------------------------------------------------------
mean


## ----object-classes-00a-------------------------------------------------------------------------------------------------
methods(mean)


## ----object-classes-00b-------------------------------------------------------------------------------------------------
methods(class = "list")


## ----explain-object-classes-01------------------------------------------------------------------------------------------
a <- 123
class(a)
class(a) <- c("myclass", class(a))
class(a)


## ----explain-object-classes-02------------------------------------------------------------------------------------------
print.myclass <- function(x) {
    sprintf("[myclass] %.0f", as.numeric(x))
}


## ----explain-object-classes-03------------------------------------------------------------------------------------------
print(a)
print(as.numeric(a))


## ----explain-object-classes-04------------------------------------------------------------------------------------------
b <- 456
class(b) <- c("derivclass", class(a))


## ----explain-object-classes-05------------------------------------------------------------------------------------------
print(b)


## ----explain-object-classes-05a-----------------------------------------------------------------------------------------
print(as.numeric(b))


## ----pkg-00, eval=FALSE-------------------------------------------------------------------------------------------------
## install.packages("learnrbook")


## ----pkg-00x, eval=FALSE------------------------------------------------------------------------------------------------
## update.packages()


## ----remotes-00y, eval=FALSE--------------------------------------------------------------------------------------------
## remotes::install_github("aphalo/learnrbook-pkg")


## ----pak-00z, eval=FALSE------------------------------------------------------------------------------------------------
## pak::pkg_install("learnrbook") # from CRAN
## pak::pkg_install("aphalo/learnrbook-pkg") # from GitHub


## ----pkg-00a, eval=FALSE------------------------------------------------------------------------------------------------
## library("learnrbook")


## ----pkg-version-01-----------------------------------------------------------------------------------------------------
packageVersion(pkg="learnrbook")


## ----citation-1---------------------------------------------------------------------------------------------------------
citation()


## ----pkg-01, eval=eval_playground---------------------------------------------------------------------------------------
class(cars)
head(cars, 3)
getAnywhere("cars")$where # defined in package


## ----pkg-01a, eval=eval_playground--------------------------------------------------------------------------------------
cars <- 1:10
class(cars)
head(cars, 3) # prints 'cars' defined in the global environment
rm(cars) # clean up
head(cars, 3)
getAnywhere("cars")$where # the first visible definition is in the global environemnt


## ----pkg-02a------------------------------------------------------------------------------------------------------------
mean


## ----pkg-02b------------------------------------------------------------------------------------------------------------
mean <- mean(1:5)
mean
mean(8:9)


## ----pkg-02c------------------------------------------------------------------------------------------------------------
getAnywhere("mean")$where
rm(mean)
getAnywhere("mean")$where


## ----pkg-03, eval=FALSE-------------------------------------------------------------------------------------------------
## datasets::cars <- "my car is green"
## rm(datasets::cars)


## ----eval=eval_diag, include=eval_diag, echo=eval_diag, cache=FALSE-----------------------------------------------------
## knitter_diag()
## R_diag()
## other_diag()

