/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MinimiserMonitor;
import jebl.math.MultivariateFunction;
import jebl.math.MultivariateMinimum;
import jebl.math.OrderEnumerator;
import jebl.math.OrthogonalHints;
import jebl.math.OrthogonalLineFunction;
import jebl.math.UnivariateMinimum;

public class OrthogonalSearch
extends MultivariateMinimum {
    private OrderEnumerator.OEFactory orthogonalOrderingFactory_;
    private boolean useCurrentInUnivariateMinimisation_ = false;
    private boolean ignoreNonMinimalUnivariateMinimisations_ = true;
    private boolean debug_ = false;
    private boolean frequentMonitoring_ = true;

    public OrthogonalSearch() {
        this(OrderEnumerator.Utils.getOrderedFactory());
    }

    public OrthogonalSearch(boolean shuffle) {
        this(shuffle ? OrderEnumerator.Utils.getShuffledFactory() : OrderEnumerator.Utils.getOrderedFactory());
    }

    public OrthogonalSearch(OrderEnumerator.OEFactory orderingFactory) {
        this.orthogonalOrderingFactory_ = orderingFactory;
    }

    public void setUseCurrentInUnivariateMinimisation(boolean value) {
        this.useCurrentInUnivariateMinimisation_ = value;
    }

    public void setIgnoreNonMinimalUnivariateMinimisations(boolean value) {
        this.ignoreNonMinimalUnivariateMinimisations_ = value;
    }

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx) {
        this.optimize(f, xvec, tolfx, tolx, null);
    }

    public void optimize(MultivariateFunction f, double[] xvec, double tolfx, double tolx, MinimiserMonitor monitor) {
        int numArgs = f.getNumArguments();
        this.numFun = 1;
        double fx = f.evaluate(xvec);
        this.stopCondition(fx, xvec, tolfx, tolx, true);
        RoundOptimiser od = this.generateOrthogonalRoundOptimiser(f);
        UnivariateMinimum um = this.generateUnivariateMinimum();
        do {
            double lastFX = fx;
            fx = od.doRound(xvec, um, tolx, fx, this.frequentMonitoring_ ? monitor : null);
            if (monitor != null) {
                monitor.newMinimum(fx, xvec, f);
                if (this.maxFun > 0) {
                    monitor.updateProgress((double)this.numFun / (double)this.maxFun);
                }
            }
            this.debug("Round fx:" + fx);
        } while (!this.stopCondition(fx, xvec, tolfx, tolx, false) && (this.maxFun <= 0 || this.numFun <= this.maxFun) && numArgs != 1);
    }

    public static final MultivariateMinimum.Factory generateFactory(boolean shuffle) {
        return new SearchFactory(shuffle);
    }

    protected UnivariateMinimum generateUnivariateMinimum() {
        return new UnivariateMinimum();
    }

    protected boolean isFrequentMonitoring() {
        return this.frequentMonitoring_;
    }

    protected RoundOptimiser generateOrthogonalRoundOptimiser(MultivariateFunction mf) {
        OrthogonalHints hints = mf.getOrthogonalHints();
        if (hints != null) {
            return new OrthogonalHintsDirection(mf, hints, this.orthogonalOrderingFactory_);
        }
        return new OrthogonalDirection(mf, this.orthogonalOrderingFactory_);
    }

    protected final boolean isUseCurrentInUnivariateMinimisation() {
        return this.useCurrentInUnivariateMinimisation_;
    }

    protected final boolean isIgnoreNonMinimalUnivariateMinimisations() {
        return this.ignoreNonMinimalUnivariateMinimisations_;
    }

    protected void debug(Object output) {
        if (this.debug_) {
            System.out.println(output);
        }
    }

    protected boolean isDebug() {
        return this.debug_;
    }

    private class OrthogonalHintsDirection
    implements RoundOptimiser {
        OrderEnumerator order_;
        OrthogonalLineFunction olf_;
        OrthogonalHints hints_;
        double[] store_ = new double[100];
        MultivariateFunction base_;

        public OrthogonalHintsDirection(MultivariateFunction mf, OrthogonalHints hints, OrderEnumerator.OEFactory orderFactory) {
            this.base_ = mf;
            this.olf_ = new OrthogonalLineFunction(this.base_);
            this.hints_ = hints;
            this.order_ = OrthogonalSearch.this.orthogonalOrderingFactory_.createOrderEnumerator(this.base_.getNumArguments());
        }

        private final double getNormalMin(UnivariateMinimum um, double argumentValue, double tolx) {
            return OrthogonalSearch.this.useCurrentInUnivariateMinimisation_ ? um.optimize(argumentValue, this.olf_, tolx) : um.optimize(this.olf_, tolx);
        }

        private final double getBoundedMin(UnivariateMinimum um, double argumentValue, double tolx, double min, double max) {
            if (OrthogonalSearch.this.useCurrentInUnivariateMinimisation_ && min <= argumentValue && max >= argumentValue) {
                return um.optimize(argumentValue, this.olf_, tolx, min, max);
            }
            return um.optimize(this.olf_, tolx, min, max);
        }

        public double doRound(double[] xvec, UnivariateMinimum um, double tolx, double fx, MinimiserMonitor monitor) {
            this.olf_.setAllArguments(xvec);
            this.order_.reset();
            while (this.order_.hasMore()) {
                double newFX;
                double newArgValue;
                int argument = this.order_.getNext();
                this.olf_.selectArgument(argument);
                int numberOfHints = this.hints_.getInternalParameterBoundaries(argument, this.store_);
                while (numberOfHints < 0) {
                    this.store_ = new double[this.store_.length + 10];
                    numberOfHints = this.hints_.getInternalParameterBoundaries(argument, this.store_);
                }
                if (numberOfHints == 0) {
                    newArgValue = this.getNormalMin(um, xvec[argument], tolx);
                    newFX = um.fminx;
                } else {
                    OrthogonalSearch.this.debug("Number of hints:" + numberOfHints);
                    double min = this.olf_.getLowerBound();
                    double x = xvec[argument];
                    newArgValue = xvec[argument];
                    newFX = Double.POSITIVE_INFINITY;
                    for (int i = 0; i < numberOfHints; ++i) {
                        x = this.getBoundedMin(um, xvec[argument], tolx, min, this.store_[i]);
                        if (um.fminx < newFX) {
                            newArgValue = x;
                            newFX = um.fminx;
                        }
                        min = this.store_[i];
                    }
                    double max = this.olf_.getUpperBound();
                    if (min != max) {
                        x = this.getBoundedMin(um, xvec[argument], tolx, min, max);
                        if (um.fminx < newFX) {
                            newArgValue = x;
                            newFX = um.fminx;
                        }
                    }
                }
                if (newFX <= fx) {
                    if (OrthogonalSearch.this.debug_ && numberOfHints > 0) {
                        this.getNormalMin(um, xvec[argument], tolx);
                    }
                    xvec[argument] = newArgValue;
                    this.olf_.setArgument(newArgValue);
                    if (monitor != null) {
                        monitor.newMinimum(newFX, xvec, this.base_);
                    }
                    fx = newFX;
                }
                if (OrthogonalSearch.this.debug_) {
                    System.out.println(argument + ":" + newFX + "  " + fx + "   " + um.fminx + "    " + (um.fminx - newFX) + "   " + (um.fminx < newFX ? "Bad" : "Good!"));
                }
                OrthogonalSearch.this.numFun += um.numFun;
            }
            return fx;
        }
    }

    private class OrthogonalDirection
    implements RoundOptimiser {
        OrderEnumerator order_;
        OrthogonalLineFunction olf_;
        MultivariateFunction base_;

        public OrthogonalDirection(MultivariateFunction mf, OrderEnumerator.OEFactory orderFactory) {
            this.base_ = mf;
            this.olf_ = new OrthogonalLineFunction(this.base_);
            this.order_ = OrthogonalSearch.this.orthogonalOrderingFactory_.createOrderEnumerator(this.base_.getNumArguments());
        }

        public double doRound(double[] xvec, UnivariateMinimum um, double tolx, double fx, MinimiserMonitor monitor) {
            this.olf_.setAllArguments(xvec);
            this.order_.reset();
            while (this.order_.hasMore()) {
                double newArgValue;
                int argument = this.order_.getNext();
                this.olf_.selectArgument(argument);
                double d = newArgValue = OrthogonalSearch.this.useCurrentInUnivariateMinimisation_ ? um.optimize(xvec[argument], this.olf_, tolx) : um.optimize(this.olf_, tolx);
                if (um.fminx <= fx) {
                    xvec[argument] = newArgValue;
                    this.olf_.setArgument(newArgValue);
                    fx = um.fminx;
                }
                if (monitor != null) {
                    monitor.newMinimum(fx, xvec, this.base_);
                }
                OrthogonalSearch.this.debug(argument + ":" + um.fminx + "  " + fx);
                OrthogonalSearch.this.numFun += um.numFun;
            }
            return fx;
        }
    }

    private static final class SearchFactory
    implements MultivariateMinimum.Factory {
        boolean shuffle_;

        private SearchFactory(boolean shuffle) {
            this.shuffle_ = shuffle;
        }

        public MultivariateMinimum generateNewMinimiser() {
            return new OrthogonalSearch(this.shuffle_);
        }
    }

    protected static interface RoundOptimiser {
        public double doRound(double[] var1, UnivariateMinimum var2, double var3, double var5, MinimiserMonitor var7);
    }
}

