/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;

@Explained
public class PropIntValuePrecedeChain
extends Propagator<IntVar> {
    private final int s;
    private final int t;
    private final int n;
    private final IStateInt a;
    private final IStateInt b;
    private final IStateInt g;

    public PropIntValuePrecedeChain(IntVar[] vars, int s, int t) {
        super((Variable[])vars, (Priority)PropagatorPriority.LINEAR, true);
        this.s = s;
        this.t = t;
        this.n = vars.length;
        IEnvironment env = vars[0].getEnvironment();
        this.a = env.makeInt();
        this.b = env.makeInt();
        this.g = env.makeInt();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int _a;
        for (_a = this.a.get(); _a < this.n && !((IntVar[])this.vars)[_a].contains(this.s); ++_a) {
            ((IntVar[])this.vars)[_a].removeValue(this.t, this, this.explainTrem(_a));
        }
        this.a.set(_a);
        this.b.set(_a);
        this.g.set(_a);
        int _g = _a;
        if (_a < this.n) {
            ((IntVar[])this.vars)[_a].removeValue(this.t, this, this.explainTrem(_a));
            while (++_g < this.n && !((IntVar[])this.vars)[_g].isInstantiatedTo(this.t)) {
            }
            this.g.set(_g);
            this.updateB();
        }
    }

    @Override
    public void propagate(int i, int mask) throws ContradictionException {
        int _b = this.b.get();
        if (_b <= this.g.get()) {
            int _a = this.a.get();
            if (i == _a && !((IntVar[])this.vars)[i].contains(this.s)) {
                ++_a;
                while (_a < _b) {
                    ((IntVar[])this.vars)[_a].removeValue(this.t, this, this.explainTrem(_a));
                    ++_a;
                }
                while (_a < this.n && !((IntVar[])this.vars)[_a].contains(this.s)) {
                    ((IntVar[])this.vars)[_a].removeValue(this.t, this, this.explainTrem(_a));
                    ++_a;
                }
                if (_a < this.n) {
                    ((IntVar[])this.vars)[_a].removeValue(this.t, this, this.explainTrem(_a));
                }
                this.a.set(_a);
                this.b.set(_a);
                if (_a < this.n) {
                    this.updateB();
                }
            } else if (i == _b && !((IntVar[])this.vars)[i].contains(this.s)) {
                this.updateB();
            }
        }
        this.checkC(i);
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            int is = -1;
            int it = -1;
            for (int i = 0; i < ((IntVar[])this.vars).length; ++i) {
                if (is == -1 && ((IntVar[])this.vars)[i].isInstantiatedTo(this.s)) {
                    is = i;
                }
                if (it != -1 || !((IntVar[])this.vars)[i].isInstantiatedTo(this.t)) continue;
                it = i;
            }
            if (it == -1) {
                return ESat.TRUE;
            }
            return ESat.eval(is > -1 && is < it);
        }
        return ESat.UNDEFINED;
    }

    private void updateB() throws ContradictionException {
        int _b = this.b.get();
        while (++_b < this.n && !((IntVar[])this.vars)[_b].contains(this.s)) {
        }
        if (_b > this.g.get()) {
            ((IntVar[])this.vars)[this.a.get()].instantiateTo(this.s, this, this.explainSin(this.a.get(), this.g.get()));
            this.setPassive();
        }
        this.b.set(_b);
    }

    private void checkC(int i) throws ContradictionException {
        if (this.b.get() < this.g.get() && i < this.g.get() && ((IntVar[])this.vars)[i].isInstantiatedTo(this.t)) {
            this.g.set(i);
            if (this.b.get() > i) {
                ((IntVar[])this.vars)[this.a.get()].instantiateTo(this.s, this, this.explainSin2(this.a.get(), this.g.get()));
                this.setPassive();
            }
        }
    }

    private Reason explainTrem(int to) {
        Reason r = Reason.undef();
        if (this.lcg()) {
            int[] lits = new int[to + 1];
            int m = 1;
            for (int i = 0; i < to; ++i) {
                lits[m++] = ((IntVar[])this.vars)[i].getLit(this.s, 1);
            }
            r = Reason.r(lits);
        }
        return r;
    }

    private Reason explainSin(int a, int g) {
        Reason r = Reason.undef();
        if (this.lcg()) {
            int[] lits = new int[g - a + 1];
            int m = 1;
            lits[m++] = ((IntVar[])this.vars)[g].getLit(this.t, 0);
            for (int i = a + 1; i < g; ++i) {
                lits[m++] = ((IntVar[])this.vars)[i].getLit(this.s, 1);
            }
            r = Reason.r(lits);
        }
        return r;
    }

    private Reason explainSin2(int a, int g) {
        Reason r = Reason.undef();
        if (this.lcg()) {
            int[] lits = new int[g + 1];
            int m = 1;
            lits[m++] = ((IntVar[])this.vars)[g].getLit(this.t, 0);
            for (int i = 0; i < g; ++i) {
                if (i == a) continue;
                lits[m++] = ((IntVar[])this.vars)[i].getLit(this.s, 1);
            }
            r = Reason.r(lits);
        }
        return r;
    }
}

