/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.integer.valselector;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.search.ValSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Random;

public class RandomIntValSelector
implements ValSelector<IntDomainVar> {
    protected Random random;

    public RandomIntValSelector() {
        this.random = new Random();
    }

    public RandomIntValSelector(long seed) {
        this.random = new Random(seed);
    }

    private int nextBound(IntDomainVar x) {
        return this.random.nextBoolean() ? x.getInf() : x.getSup();
    }

    @Override
    public int getBestVal(IntDomainVar x) {
        if (x.hasEnumeratedDomain()) {
            if (x.isInstantiated()) {
                return x.getVal();
            }
            if (x.hasBooleanDomain()) {
                return this.nextBound(x);
            }
            int val = this.random.nextInt(x.getDomainSize());
            DisposableIntIterator iterator = x.getDomain().getIterator();
            for (int i = 0; i < val; ++i) {
                iterator.next();
            }
            int res = iterator.next();
            iterator.dispose();
            return res;
        }
        return this.nextBound(x);
    }
}

