/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.distances.CannotBuildDistanceMatrixException;
import jebl.evolution.sequences.State;
import jebl.util.ProgressListener;

public class JukesCantorDistanceMatrix
extends BasicDistanceMatrix {
    public JukesCantorDistanceMatrix(Alignment alignment, ProgressListener progress) throws CannotBuildDistanceMatrixException {
        this(alignment, progress, false);
    }

    public JukesCantorDistanceMatrix(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
        super(alignment.getTaxa(), new Initializer().getDistances(alignment, progress, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable));
    }

    private static class Initializer
    implements BasicDistanceMatrix.PairwiseDistanceCalculator {
        private double maxTheoreticalSubsRate;
        private Alignment alignment;
        private static final double MAX_DISTANCE = 1000.0;

        private Initializer() {
        }

        private double anySubstitutionRatio(int taxon1, int taxon2) throws CannotBuildDistanceMatrixException {
            double sumDistance = 0.0;
            double sumWeight = 0.0;
            boolean noGapsPairFound = false;
            if (this.alignment.getPatterns().size() == 0) {
                return 0.0;
            }
            for (Pattern pattern : this.alignment.getPatterns()) {
                State state1 = pattern.getState(taxon1);
                State state2 = pattern.getState(taxon2);
                double weight = pattern.getWeight();
                if (state1.isAmbiguous() || state2.isAmbiguous() || state1.isGap() || state2.isGap()) continue;
                noGapsPairFound = true;
                if (state1 != state2) {
                    sumDistance += weight;
                }
                sumWeight += weight;
            }
            if (!noGapsPairFound) {
                throw new CannotBuildDistanceMatrixException("Jukes-Cantor", this.getTaxonName(taxon1), this.getTaxonName(taxon2));
            }
            double distance = sumDistance / sumWeight;
            return distance;
        }

        public double calculatePairwiseDistance(int taxon1, int taxon2) throws CannotBuildDistanceMatrixException {
            double obsDist = this.anySubstitutionRatio(taxon1, taxon2);
            if (obsDist == 0.0) {
                return 0.0;
            }
            if (obsDist >= this.maxTheoreticalSubsRate) {
                return 1000.0;
            }
            double expDist = -this.maxTheoreticalSubsRate * Math.log(1.0 - 1.0 / this.maxTheoreticalSubsRate * obsDist);
            return Math.min(expDist, 1000.0);
        }

        synchronized double[][] getDistances(Alignment alignment, ProgressListener progress, boolean useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable) throws CannotBuildDistanceMatrixException {
            this.alignment = alignment;
            int stateCount = alignment.getSequenceType().getCanonicalStateCount();
            this.maxTheoreticalSubsRate = ((double)stateCount - 1.0) / (double)stateCount;
            int dimension = alignment.getTaxa().size();
            return BasicDistanceMatrix.buildDistancesMatrix(this, dimension, useTwiceMaximumDistanceWhenPairwiseDistanceNotCalculatable, progress);
        }

        private String getTaxonName(int index) {
            return this.alignment.getSequenceList().get(index).getTaxon().getName();
        }
    }
}

