/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treelikelihood.utilities;

import java.util.Set;

public interface HistoryFilter {
    public boolean filter(String var1, String var2, double var3);

    public String getDescription();

    public static class SetFilter
    implements HistoryFilter {
        private final Set<String> sources;
        private final Set<String> destinations;
        final double maxTime;
        final double minTime;

        public SetFilter(Set<String> set, Set<String> set2, double d, double d2) {
            this.sources = set;
            this.destinations = set2;
            this.maxTime = d;
            this.minTime = d2;
        }

        @Override
        public String getDescription() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.minTime).append(" <= event time <= ").append(this.maxTime);
            return stringBuilder.toString();
        }

        @Override
        public boolean filter(String string, String string2, double d) {
            if (this.sources == null && this.destinations == null) {
                return d <= this.maxTime && d >= this.minTime;
            }
            return this.sources.contains(string) && this.destinations.contains(string2) && d <= this.maxTime && d >= this.minTime;
        }
    }

    public static class Default
    implements HistoryFilter {
        @Override
        public String getDescription() {
            return "Default";
        }

        @Override
        public boolean filter(String string, String string2, double d) {
            return true;
        }
    }
}

