/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.tramoseats.base.core.seats.IModelValidator;

public class DefaultModelValidator
implements IModelValidator {
    private final double xl;
    private final double eps;
    private SarimaModel newModel;

    public static Builder builder() {
        return new Builder();
    }

    private DefaultModelValidator(double xl, double eps) {
        this.xl = xl;
        this.eps = eps;
    }

    @Override
    public SarimaModel getNewModel() {
        return this.newModel;
    }

    public double getXl() {
        return this.xl;
    }

    private boolean stabilizeMA(double ur, double[] p) {
        if (p.length == 1) {
            double q = p[0];
            if (q < -ur) {
                p[0] = -ur;
                return true;
            }
            if (q > ur) {
                p[0] = ur;
                return true;
            }
            return false;
        }
        Polynomial P = Polynomial.valueOf((double)1.0, (double[])p);
        boolean changed = false;
        Complex[] roots = P.roots();
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double q = 1.0 / roots[i].abs();
            if (!(q > ur)) continue;
            changed = true;
            roots[i] = root.times(q / ur);
        }
        if (!changed) {
            return false;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots((Complex[])roots);
        ptmp = ptmp.divide(ptmp.get(0));
        for (int i = 0; i < p.length; ++i) {
            p[i] = ptmp.get(i + 1);
        }
        return true;
    }

    @Override
    public boolean validate(SarimaModel model) {
        this.newModel = model;
        boolean smp = this.simplifyModel();
        boolean ma = this.changeMA();
        boolean ar = this.changeAR();
        return !smp && !ma && !ar;
    }

    private boolean changeAR() {
        return false;
    }

    private boolean fixMaUnitRoots() {
        boolean changed = false;
        double ur = 1.0 - this.eps;
        double[] q = this.newModel.getTheta().toArray();
        double[] bq = this.newModel.getBtheta().toArray();
        if (bq.length > 0) {
            double bth = bq[0];
            double sur = Math.pow(ur, this.newModel.getPeriod());
            if (bth < -sur) {
                bq[0] = -1.0;
                changed = true;
            } else if (bth > sur) {
                bq[0] = 1.0;
                changed = true;
            }
        }
        if (q.length == 1) {
            double th = q[0];
            if (th < -ur) {
                q[0] = -1.0;
                changed = true;
            } else if (th > ur) {
                q[0] = -1.0;
                changed = true;
            }
        } else if (q.length > 1) {
            int i;
            Polynomial Q = Polynomial.valueOf((double)1.0, (double[])q);
            Complex[] roots = Q.roots();
            boolean qchanged = false;
            for (i = 0; i < roots.length; ++i) {
                double l = roots[i].abs();
                if (!(l < ur)) continue;
                qchanged = true;
                roots[i] = roots[i].div(l);
            }
            if (qchanged) {
                Q = Polynomial.fromComplexRoots((Complex[])roots);
                for (i = 0; i < q.length; ++i) {
                    q[i] = Q.get(i + 1);
                }
                changed = true;
            }
        }
        if (changed) {
            this.newModel = this.newModel.toBuilder().theta(q).btheta(bq).build();
            return true;
        }
        return false;
    }

    private boolean changeMA() {
        if (this.xl < 1.0) {
            boolean rslt = false;
            double[] q = this.newModel.getTheta().toArray();
            double[] bq = this.newModel.getBtheta().toArray();
            if (this.stabilizeMA(this.xl, q)) {
                rslt = true;
            }
            if (this.stabilizeMA(this.xl, bq)) {
                rslt = true;
            }
            if (rslt) {
                this.newModel = this.newModel.toBuilder().theta(q).btheta(bq).build();
                return true;
            }
            return false;
        }
        return this.fixMaUnitRoots();
    }

    private boolean simplifyModel() {
        if (this.canSimplify(this.newModel.getPhi()) || this.canSimplify(this.newModel.getBphi()) || this.canSimplify(this.newModel.getTheta()) || this.canSimplify(this.newModel.getBtheta())) {
            this.newModel = this.newModel.toBuilder().adjustOrders(true).build();
            return true;
        }
        return false;
    }

    private boolean canSimplify(DoubleSeq p) {
        return p.length() > 0 && Math.abs(p.get(p.length() - 1)) < 1.0E-6;
    }

    public static class Builder {
        public static final double DEF_XL = 0.95;
        public static final double DEF_EPS = 1.0E-4;
        private double xl = 0.95;
        private double eps = 1.0E-4;

        public Builder xl(double xl) {
            this.xl = xl;
            return this;
        }

        public Builder urTolerance(double eps) {
            this.eps = eps;
            return this;
        }

        public DefaultModelValidator build() {
            return new DefaultModelValidator(this.xl, this.eps);
        }
    }
}

