/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.stats.likelihood;

import java.util.function.Function;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.IFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.IFunctionPoint;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class LogLikelihoodFunction<T, L extends Likelihood>
implements IFunction {
    private final IParametricMapping<T> mapping;
    private final Function<T, L> function;

    public LogLikelihoodFunction(IParametricMapping<T> mapping, Function<T, L> function) {
        this.mapping = mapping;
        this.function = function;
    }

    public IParametricMapping<T> getMapping() {
        return this.mapping;
    }

    @Override
    public IFunctionPoint evaluate(DoubleSeq parameters) {
        return new llPoint(parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    public Point point(DoubleSeq parameters) {
        IFunctionDerivatives d = this.evaluate(parameters).derivatives();
        FastMatrix H = d.hessian();
        H.chs();
        return new Point(this, parameters, d.gradient(), H);
    }

    private class llPoint
    implements IFunctionPoint {
        private final DoubleSeq parameters;
        private final T t;

        llPoint(DoubleSeq parameters) {
            this.parameters = parameters;
            this.t = LogLikelihoodFunction.this.mapping.map(parameters);
        }

        @Override
        public IFunction getFunction() {
            return LogLikelihoodFunction.this;
        }

        @Override
        public DoubleSeq getParameters() {
            return this.parameters;
        }

        @Override
        public double getValue() {
            Likelihood l = (Likelihood)LogLikelihoodFunction.this.function.apply(this.t);
            if (l == null) {
                return Double.NaN;
            }
            return l.logLikelihood();
        }
    }

    public static final class Point<T, L extends Likelihood> {
        private final LogLikelihoodFunction<T, L> function;
        private final DoubleSeq parameters;
        private final DoubleSeq score;
        private final FastMatrix information;

        public static <T, L extends Likelihood> Point ofNegativeLogLikelihood(LogLikelihoodFunction<T, L> function, DoubleSeq p, DoubleSeq grad, FastMatrix hessian) {
            return new Point<T, L>(function, p, grad.fn(x -> -x), hessian);
        }

        public FastMatrix asymptoticCovariance() {
            return SymmetricMatrix.inverse(this.information);
        }

        @Generated
        public Point(LogLikelihoodFunction<T, L> function, DoubleSeq parameters, DoubleSeq score, FastMatrix information) {
            this.function = function;
            this.parameters = parameters;
            this.score = score;
            this.information = information;
        }

        @Generated
        public LogLikelihoodFunction<T, L> getFunction() {
            return this.function;
        }

        @Generated
        public DoubleSeq getParameters() {
            return this.parameters;
        }

        @Generated
        public DoubleSeq getScore() {
            return this.score;
        }

        @Generated
        public FastMatrix getInformation() {
            return this.information;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Point)) {
                return false;
            }
            Point other = (Point)o;
            LogLikelihoodFunction<T, L> this$function = this.getFunction();
            LogLikelihoodFunction<T, L> other$function = other.getFunction();
            if (this$function == null ? other$function != null : !this$function.equals(other$function)) {
                return false;
            }
            DoubleSeq this$parameters = this.getParameters();
            DoubleSeq other$parameters = other.getParameters();
            if (this$parameters == null ? other$parameters != null : !this$parameters.equals(other$parameters)) {
                return false;
            }
            DoubleSeq this$score = this.getScore();
            DoubleSeq other$score = other.getScore();
            if (this$score == null ? other$score != null : !this$score.equals(other$score)) {
                return false;
            }
            FastMatrix this$information = this.getInformation();
            FastMatrix other$information = other.getInformation();
            return !(this$information == null ? other$information != null : !this$information.equals(other$information));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LogLikelihoodFunction<T, L> $function = this.getFunction();
            result = result * 59 + ($function == null ? 43 : $function.hashCode());
            DoubleSeq $parameters = this.getParameters();
            result = result * 59 + ($parameters == null ? 43 : $parameters.hashCode());
            DoubleSeq $score = this.getScore();
            result = result * 59 + ($score == null ? 43 : $score.hashCode());
            FastMatrix $information = this.getInformation();
            result = result * 59 + ($information == null ? 43 : $information.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "LogLikelihoodFunction.Point(function=" + String.valueOf(this.getFunction()) + ", parameters=" + String.valueOf(this.getParameters()) + ", score=" + String.valueOf(this.getScore()) + ", information=" + String.valueOf(this.getInformation()) + ")";
        }
    }
}

