/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.ParamValidation;

public class ParametersRange
implements IParametersDomain {
    private final int m_np;
    private final double a;
    private final double b;
    private final boolean m_excluded;
    private double m_eps = 1.0E-6;

    public ParametersRange(double a, double b, boolean excluded) {
        this.m_np = 1;
        this.a = a;
        this.b = b;
        this.m_excluded = excluded;
    }

    public ParametersRange(int nparams, double a, double b, boolean excluded) {
        this.m_np = nparams;
        this.a = a;
        this.b = b;
        this.m_excluded = excluded;
    }

    @Override
    public boolean checkBoundaries(DoubleSeq inparams) {
        for (int i = 0; i < this.m_np; ++i) {
            double v = inparams.get(i);
            if (!(this.isOpen() ? v <= this.getA() || v >= this.getB() : v < this.getA() || v > this.getB())) continue;
            return false;
        }
        return true;
    }

    @Override
    public double epsilon(DoubleSeq inparams, int idx) {
        double eps = (this.getB() - this.getA()) * this.m_eps;
        if (inparams.get(idx) + eps >= this.getB()) {
            eps = -eps;
        }
        return eps;
    }

    public double getDelta() {
        return this.m_eps;
    }

    @Override
    public int getDim() {
        return this.m_np;
    }

    @Override
    public double lbound(int idx) {
        return this.isOpen() ? this.getA() + this.m_eps : this.getA();
    }

    public void setDelta(double value) {
        this.m_eps = value;
    }

    @Override
    public double ubound(int idx) {
        return this.isOpen() ? this.getB() - this.m_eps : this.getB();
    }

    @Override
    public ParamValidation validate(DataBlock ioparams) {
        ParamValidation rslt = ParamValidation.Valid;
        for (int i = 0; i < this.m_np; ++i) {
            double v = ioparams.get(i);
            if (this.isOpen()) {
                double eps;
                if (v <= this.getA()) {
                    eps = (this.getB() - this.getA()) * this.m_eps;
                    ioparams.set(i, this.getA() + eps);
                    rslt = ParamValidation.Changed;
                    continue;
                }
                if (!(v >= this.getB())) continue;
                eps = (this.getB() - this.getA()) * this.m_eps;
                ioparams.set(i, this.getB() - eps);
                rslt = ParamValidation.Changed;
                continue;
            }
            if (v < this.getA()) {
                ioparams.set(i, this.getA());
                rslt = ParamValidation.Changed;
                continue;
            }
            if (!(v > this.getB())) continue;
            ioparams.set(i, this.getB());
            rslt = ParamValidation.Changed;
        }
        return rslt;
    }

    @Override
    public String getDescription(int idx) {
        return "parameter " + idx;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public boolean isOpen() {
        return this.m_excluded;
    }
}

