/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing.trail;

import choco.kernel.memory.trailing.StoredInt;
import choco.kernel.memory.trailing.trail.ITrailStorage;

public final class StoredIntTrail
implements ITrailStorage {
    private StoredInt[] variableStack;
    private int[] valueStack;
    private int[] stampStack;
    private int currentLevel = 0;
    private int[] worldStartLevels;
    private int maxUpdates = 0;

    public StoredIntTrail(int nUpdates, int nWorlds) {
        this.maxUpdates = nUpdates;
        this.variableStack = new StoredInt[this.maxUpdates];
        this.valueStack = new int[this.maxUpdates];
        this.stampStack = new int[this.maxUpdates];
        this.worldStartLevels = new int[nWorlds];
    }

    @Override
    public void clear() {
        this.currentLevel = 0;
    }

    @Override
    public void worldPush(int wi) {
        this.worldStartLevels[wi] = this.currentLevel;
    }

    @Override
    public void worldPop(int wi) {
        while (this.currentLevel > this.worldStartLevels[wi]) {
            --this.currentLevel;
            StoredInt v = this.variableStack[this.currentLevel];
            v._set(this.valueStack[this.currentLevel], this.stampStack[this.currentLevel]);
        }
    }

    @Override
    public int getSize() {
        return this.currentLevel;
    }

    @Override
    public void worldCommit(int wi) {
        int startLevel = this.worldStartLevels[wi];
        int prevWorld = wi - 1;
        int writeIdx = startLevel;
        for (int level = startLevel; level < this.currentLevel; ++level) {
            StoredInt var = this.variableStack[level];
            int val = this.valueStack[level];
            int stamp = this.stampStack[level];
            var.worldStamp = prevWorld;
            if (stamp == prevWorld) continue;
            if (writeIdx != level) {
                this.valueStack[writeIdx] = val;
                this.variableStack[writeIdx] = var;
                this.stampStack[writeIdx] = stamp;
            }
            ++writeIdx;
        }
        this.currentLevel = writeIdx;
    }

    public void savePreviousState(StoredInt v, int oldValue, int oldStamp) {
        this.valueStack[this.currentLevel] = oldValue;
        this.variableStack[this.currentLevel] = v;
        this.stampStack[this.currentLevel] = oldStamp;
        ++this.currentLevel;
        if (this.currentLevel == this.maxUpdates) {
            this.resizeUpdateCapacity();
        }
    }

    private void resizeUpdateCapacity() {
        int newCapacity = this.maxUpdates * 3 / 2;
        StoredInt[] tmp1 = new StoredInt[newCapacity];
        System.arraycopy(this.variableStack, 0, tmp1, 0, this.variableStack.length);
        this.variableStack = tmp1;
        int[] tmp2 = new int[newCapacity];
        System.arraycopy(this.valueStack, 0, tmp2, 0, this.valueStack.length);
        this.valueStack = tmp2;
        int[] tmp3 = new int[newCapacity];
        System.arraycopy(this.stampStack, 0, tmp3, 0, this.stampStack.length);
        this.stampStack = tmp3;
        this.maxUpdates = newCapacity;
    }

    @Override
    public void resizeWorldCapacity(int newWorldCapacity) {
        int[] tmp = new int[newWorldCapacity];
        System.arraycopy(this.worldStartLevels, 0, tmp, 0, this.worldStartLevels.length);
        this.worldStartLevels = tmp;
    }
}

