/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import main.AlleleProbs;
import vcf.Marker;
import vcf.Markers;

public class ConstrainedAlleleProbs
implements AlleleProbs {
    private final AlleleProbs alProbs;
    private final SampleHapPairs shp;
    private final int[] indexMap;

    public ConstrainedAlleleProbs(SampleHapPairs sampleHapPairs, AlleleProbs alleleProbs, int[] nArray) {
        if (alleleProbs.nMarkers() != nArray.length) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1 || alleleProbs.marker(i).equals(sampleHapPairs.marker(nArray[i]))) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (!sampleHapPairs.samples().equals(alleleProbs.samples())) {
            throw new IllegalArgumentException("inconsistent sample");
        }
        this.shp = sampleHapPairs;
        this.alProbs = alleleProbs;
        this.indexMap = (int[])nArray.clone();
    }

    public boolean isImputed(int n) {
        return this.indexMap[n] == -1;
    }

    @Override
    public float alProb1(int n, int n2, int n3) {
        int n4 = this.indexMap[n];
        if (n4 == -1) {
            return this.alProbs.alProb1(n, n2, n3);
        }
        return this.shp.allele1(n4, n2) == n3 ? 1.0f : 0.0f;
    }

    @Override
    public float alProb2(int n, int n2, int n3) {
        int n4 = this.indexMap[n];
        if (n4 == -1) {
            return this.alProbs.alProb2(n, n2, n3);
        }
        return this.shp.allele2(n4, n2) == n3 ? 1.0f : 0.0f;
    }

    @Override
    public float gtProb(int n, int n2, int n3, int n4) {
        return this.alProb1(n, n2, n3) * this.alProb2(n, n2, n4);
    }

    @Override
    public int allele1(int n, int n2) {
        int n3 = this.indexMap[n];
        if (n3 == -1) {
            return this.alProbs.allele1(n, n2);
        }
        return this.shp.allele1(n3, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        int n3 = this.indexMap[n];
        if (n3 == -1) {
            return this.alProbs.allele2(n, n2);
        }
        return this.shp.allele2(n3, n2);
    }

    @Override
    public int nMarkers() {
        return this.alProbs.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.alProbs.markers();
    }

    @Override
    public Marker marker(int n) {
        return this.alProbs.marker(n);
    }

    @Override
    public int nSamples() {
        return this.alProbs.nSamples();
    }

    @Override
    public Samples samples() {
        return this.alProbs.samples();
    }
}

