/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;
import org.vikamine.kernel.util.VKMUtil;

public class DyadicLiftCompletedQF
extends AbstractQFStatisticBased {
    private static final String ID = "DyadicLiftQF";
    private static final String NAME = "DyadicLift";

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new DyadicLiftCompletedQF();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return true;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double observedDyads = statistics.getSubgroupSize();
        double expectedDyads = VKMUtil.asList(subgroup.subgroupInstanceIterator()).size();
        return Math.abs(observedDyads / expectedDyads);
    }

    public String getDyads(SGStatistics statistics) {
        SG subgroup = statistics.getSubgroup();
        double observedDyads = statistics.getSubgroupSize();
        double expectedDyads = VKMUtil.asList(subgroup.subgroupInstanceIterator()).size();
        return String.valueOf(observedDyads) + "\t" + expectedDyads;
    }
}

