/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.dataEditor.panels;

import dmLab.array.loader.fileLoader.FileType;
import dmLab.gui.dataEditor.components.GlyphButton;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.fileFilters.MyFileFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class AttrFilterPanel
extends JPanel
implements ActionListener {
    private JButton browseButton;
    private JTextField filePath;
    public GlyphButton filterButton;
    private JComboBox measureName;
    private JTextField attrNumber;
    private JCheckBox inverseCheckBox;
    private JFileChooser fileDialog;
    public AttributesRI importances;

    public AttrFilterPanel() {
        AttrFilterPanel attrFilterPanel = this;
        attrFilterPanel.setPreferredSize(new Dimension(301, 119));
        attrFilterPanel.setLayout(null);
        attrFilterPanel.fileDialog = new JFileChooser();
        MyFileFilter[] myFileFilterArray = FileType.getSupportedTypes();
        for (int i = 0; i < myFileFilterArray.length; ++i) {
            attrFilterPanel.fileDialog.addChoosableFileFilter(myFileFilterArray[i]);
        }
        attrFilterPanel.inverseCheckBox = new JCheckBox();
        AttrFilterPanel attrFilterPanel2 = attrFilterPanel;
        attrFilterPanel2.add(attrFilterPanel2.inverseCheckBox);
        attrFilterPanel.inverseCheckBox.setText("Inverse");
        attrFilterPanel.inverseCheckBox.setBounds(91, 84, 70, 28);
        attrFilterPanel.inverseCheckBox.setSelected(false);
        attrFilterPanel.attrNumber = new JTextField();
        AttrFilterPanel attrFilterPanel3 = attrFilterPanel;
        attrFilterPanel3.add(attrFilterPanel3.attrNumber);
        attrFilterPanel.attrNumber.setText("30");
        attrFilterPanel.attrNumber.setBounds(20, 84, 63, 28);
        attrFilterPanel.browseButton = new JButton();
        AttrFilterPanel attrFilterPanel4 = attrFilterPanel;
        attrFilterPanel4.add(attrFilterPanel4.browseButton);
        attrFilterPanel.browseButton.setText("Browse");
        attrFilterPanel.browseButton.setBounds(210, 7, 91, 28);
        attrFilterPanel.filePath = new JTextField();
        AttrFilterPanel attrFilterPanel5 = attrFilterPanel;
        attrFilterPanel5.add(attrFilterPanel5.filePath);
        attrFilterPanel.filePath.setText("Histogram file path");
        attrFilterPanel.filePath.setBounds(15, 10, 190, 30);
        attrFilterPanel.filterButton = new GlyphButton("images/filter.jpg", "Filter Attributes");
        attrFilterPanel.filterButton.setToolTipText("Filter Attributes.");
        AttrFilterPanel attrFilterPanel6 = attrFilterPanel;
        attrFilterPanel6.add(attrFilterPanel6.filterButton);
        attrFilterPanel.filterButton.setBounds(210, 50, 90, 40);
        attrFilterPanel.browseButton.addActionListener(attrFilterPanel);
        attrFilterPanel.measureName = new JComboBox();
        AttrFilterPanel attrFilterPanel7 = attrFilterPanel;
        attrFilterPanel7.add(attrFilterPanel7.measureName);
        attrFilterPanel.measureName.setModel(new DefaultComboBoxModel<String>(new String[]{"RI"}));
        attrFilterPanel.measureName.setBounds(15, 50, 190, 30);
        attrFilterPanel.init();
    }

    public final boolean inverseFiltering() {
        return this.inverseCheckBox.isSelected();
    }

    public final String getMeasureName() {
        return (String)this.measureName.getModel().getSelectedItem();
    }

    public final int getAttrNumber() {
        return Integer.parseInt(this.attrNumber.getText());
    }

    @Override
    public final void actionPerformed(ActionEvent event) {
        int n;
        Object object = event.getSource();
        if (object == this.browseButton && (n = ((AttrFilterPanel)object).fileDialog.showOpenDialog((Component)(object = this))) == 0) {
            Serializable serializable = ((AttrFilterPanel)object).fileDialog.getSelectedFile();
            System.out.println("Opening: " + ((File)serializable).getName());
            ((AttrFilterPanel)object).importances = new AttributesRI();
            if (((AttrFilterPanel)object).importances.load(((File)serializable).getAbsolutePath())) {
                System.out.println("Histogram file loaded.");
                ((AttrFilterPanel)object).filePath.setText(((File)serializable).getAbsolutePath());
                serializable = new DefaultComboBoxModel<String>(((AttrFilterPanel)object).importances.getMeasuresNames());
                ((AttrFilterPanel)object).measureName.setModel(serializable);
                object = ((AttrFilterPanel)object).importances.getMeasuresNames()[((AttrFilterPanel)object).importances.getMeasuresNames().length - 1];
                serializable.setSelectedItem(object);
                return;
            }
            System.err.println("Error loading histogram file.");
        }
    }

    public final void init() {
        this.importances = null;
        this.attrNumber.setText("30");
        this.filePath.setText("Histogram file path");
        this.measureName.setModel(new DefaultComboBoxModel<String>(new String[]{"RI_u1.0_v1.0"}));
        this.inverseCheckBox.setSelected(false);
    }
}

