/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data;

import java.io.Serializable;
import java.util.BitSet;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.util.Resolvable;

public final class VerbFrame
implements Serializable {
    static final long serialVersionUID = 1450633678809744269L;
    private static VerbFrame[] _verbFrames;
    private static boolean _initalized;
    private Resolvable _frame;
    private int _index;
    private String _cachedToString = null;

    static {
        _initalized = false;
    }

    public static void initialize() {
        if (!_initalized) {
            int framesSize = Integer.parseInt(JWNL.resolveMessage("NUMBER_OF_VERB_FRAMES"));
            _verbFrames = new VerbFrame[framesSize];
            int i = 1;
            while (i <= framesSize) {
                VerbFrame._verbFrames[i - 1] = new VerbFrame(VerbFrame.getKeyString(i), i);
                ++i;
            }
            _initalized = true;
        }
    }

    public static final String getKeyString(int i) {
        StringBuffer buf = new StringBuffer();
        buf.append("VERB_FRAME_");
        int numZerosToAppend = 3 - String.valueOf(i).length();
        int j = 0;
        while (j < numZerosToAppend) {
            buf.append(0);
            ++j;
        }
        buf.append(i);
        return buf.toString();
    }

    public static int getVerbFramesSize() {
        return _verbFrames.length;
    }

    public static String getFrame(int index) {
        return _verbFrames[index - 1].getFrame();
    }

    public static String[] getFrames(BitSet bits) {
        int[] indicies = VerbFrame.getVerbFrameIndicies(bits);
        String[] frames = new String[indicies.length];
        int i = 0;
        while (i < indicies.length) {
            frames[i] = _verbFrames[i].getFrame();
            ++i;
        }
        return frames;
    }

    public static int[] getVerbFrameIndicies(BitSet bits) {
        int[] indicies = new int[bits.cardinality()];
        int i = 0;
        while (i < indicies.length) {
            indicies[i] = bits.nextSetBit(i == 0 ? 0 : indicies[i - 1]);
            ++i;
        }
        return indicies;
    }

    private VerbFrame(String frame, int index) {
        this._frame = new Resolvable(frame);
        this._index = index;
    }

    public String getFrame() {
        return this._frame.toString();
    }

    public int getIndex() {
        return this._index;
    }

    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_007", this.getFrame());
        }
        return this._cachedToString;
    }

    public int hashCode() {
        return this.getIndex();
    }
}

