/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.integer.AbstractIntSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.THashSet;
import java.util.Iterator;

public class ReifiedIntSConstraint
extends AbstractLargeIntSConstraint {
    AbstractIntSConstraint cons;
    AbstractIntSConstraint oppositeCons;
    protected int[] scopeCons;
    protected int[] scopeOCons;
    int[] tupleCons;
    int[] tupleOCons;

    private static IntDomainVar[] makeTableVar(IntDomainVar bool, AbstractIntSConstraint cons, AbstractIntSConstraint oppcons) {
        int i;
        THashSet<Object> consV = new THashSet<Object>(cons.getNbVars() + oppcons.getNbVars() + 1);
        for (i = 0; i < cons.getNbVars(); ++i) {
            consV.add(cons.getVar(i));
        }
        for (i = 0; i < oppcons.getNbVars(); ++i) {
            consV.add(oppcons.getVar(i));
        }
        consV.add(bool);
        IntDomainVar[] vars = new IntDomainVar[consV.size()];
        consV.remove(bool);
        vars[0] = bool;
        int i2 = 1;
        Iterator i$ = consV.iterator();
        while (i$.hasNext()) {
            IntDomainVar var;
            vars[i2] = var = (IntDomainVar)i$.next();
            ++i2;
        }
        return vars;
    }

    ReifiedIntSConstraint(IntDomainVar bool, AbstractIntSConstraint cons, Solver solver) {
        this(bool, cons, (AbstractIntSConstraint)cons.opposite(solver));
    }

    ReifiedIntSConstraint(IntDomainVar bool, AbstractIntSConstraint cons, AbstractIntSConstraint oppositeCons) {
        super(Math.max(cons.getPriority(), oppositeCons.getPriority()), ReifiedIntSConstraint.makeTableVar(bool, cons, oppositeCons));
        this.cons = cons;
        this.oppositeCons = oppositeCons;
        this.init();
    }

    @Override
    public void addExtension(int extensionNumber) {
        super.addExtension(extensionNumber);
        Extension ext = this.extensions[extensionNumber];
        this.cons.setExtension(ext, extensionNumber);
        this.oppositeCons.setExtension(ext, extensionNumber);
    }

    void init() {
        int j;
        IntDomainVar v;
        int i;
        this.tupleCons = new int[this.cons.getNbVars()];
        this.tupleOCons = new int[this.oppositeCons.getNbVars()];
        this.scopeCons = new int[this.cons.getNbVars()];
        this.scopeOCons = new int[this.oppositeCons.getNbVars()];
        block0: for (i = 0; i < this.cons.getNbVars(); ++i) {
            v = (IntDomainVar)this.cons.getVar(i);
            for (j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (!v.equals(((IntDomainVar[])this.vars)[j])) continue;
                this.scopeCons[i] = j;
                continue block0;
            }
        }
        block2: for (i = 0; i < this.oppositeCons.getNbVars(); ++i) {
            v = (IntDomainVar)this.oppositeCons.getVar(i);
            for (j = 0; j < ((IntDomainVar[])this.vars).length; ++j) {
                if (!v.equals(((IntDomainVar[])this.vars)[j])) continue;
                this.scopeOCons[i] = j;
                continue block2;
            }
        }
    }

    void filterReifiedConstraintFromBool() throws ContradictionException {
        if (((IntDomainVar[])this.vars)[0].isInstantiatedTo(1)) {
            this.cons.awake();
        } else {
            this.oppositeCons.awake();
        }
    }

    public void filterReifiedConstraintFromCons() throws ContradictionException {
        Boolean isEntailed = this.cons.isEntailed();
        if (isEntailed != null) {
            if (isEntailed.booleanValue()) {
                ((IntDomainVar[])this.vars)[0].instantiate(1, this, false);
            } else {
                ((IntDomainVar[])this.vars)[0].instantiate(0, this, true);
            }
        }
    }

    @Override
    public final int getFilteredEventMask(int idx) {
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            return 4;
        }
        return 3;
    }

    public final void filter() throws ContradictionException {
        if (((IntDomainVar[])this.vars)[0].isInstantiated()) {
            this.filterReifiedConstraintFromBool();
        } else {
            this.filterReifiedConstraintFromCons();
        }
    }

    @Override
    public final void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnInf(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnSup(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnInst(int idx) throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public final void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awake() throws ContradictionException {
        this.filter();
    }

    void addListener(AbstractIntSConstraint thecons) {
        if (thecons instanceof ReifiedIntSConstraint) {
            ReifiedIntSConstraint rcons = (ReifiedIntSConstraint)thecons;
            this.addListener(rcons.cons);
            this.addListener(rcons.oppositeCons);
        }
        int n = thecons.getNbVars();
        for (int i = 0; i < n; ++i) {
            thecons.setConstraintIndex(i, this.getIndex((AbstractVar)thecons.getVar(i)));
        }
    }

    int getIndex(AbstractVar v) {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (((IntDomainVar[])this.vars)[i] != v) continue;
            return this.cIndices[i];
        }
        return -1;
    }

    @Override
    public void addListener(boolean dynamicAddition) {
        super.addListener(dynamicAddition);
        this.addListener(this.cons);
        this.addListener(this.oppositeCons);
    }

    @Override
    public void setPropagationEngine(PropagationEngine propEng) {
        super.setPropagationEngine(propEng);
        this.cons.setPropagationEngine(propEng);
        this.oppositeCons.setPropagationEngine(propEng);
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(" 1");
        sb.append("<=>").append(this.cons.pretty());
        if (this.oppositeCons != null) {
            sb.append(" -- 0");
            sb.append("<=>").append(this.oppositeCons.pretty());
        }
        sb.append(')');
        sb.append('~').append(((IntDomainVar[])this.vars)[0].pretty());
        return sb.toString();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int i;
        int val = tuple[0];
        for (i = 0; i < this.tupleCons.length; ++i) {
            this.tupleCons[i] = tuple[this.scopeCons[i]];
        }
        if (val == 1) {
            return this.cons.isSatisfied(this.tupleCons);
        }
        for (i = 0; i < this.tupleOCons.length; ++i) {
            this.tupleOCons[i] = tuple[this.scopeOCons[i]];
        }
        return this.oppositeCons.isSatisfied(this.tupleOCons);
    }
}

