/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.reified;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.Extension;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.SConstraintType;
import choco.kernel.solver.propagation.PropagationEngine;
import choco.kernel.solver.propagation.listener.IntPropagator;
import choco.kernel.solver.propagation.listener.RealPropagator;
import choco.kernel.solver.propagation.listener.SetPropagator;
import choco.kernel.solver.variables.AbstractVar;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.THashSet;
import java.util.Iterator;

public class ReifiedAllSConstraint
extends AbstractSConstraint
implements IntPropagator,
SetPropagator,
RealPropagator {
    protected final AbstractSConstraint cons;
    protected final AbstractSConstraint oppositeCons;
    private final IntDomainVar bool;

    public static <C extends AbstractSConstraint> Var[] makeTableVar(IntDomainVar bool, C cons, C oppcons) {
        int i;
        THashSet<Object> consV = new THashSet<Object>(cons.getNbVars() + oppcons.getNbVars() + 1);
        for (i = 0; i < cons.getNbVars(); ++i) {
            consV.add(cons.getVar(i));
        }
        for (i = 0; i < oppcons.getNbVars(); ++i) {
            consV.add(oppcons.getVar(i));
        }
        consV.add(bool);
        Var[] vars = new Var[consV.size()];
        consV.remove(bool);
        vars[0] = bool;
        int i2 = 1;
        Iterator i$ = consV.iterator();
        while (i$.hasNext()) {
            Var var;
            vars[i2] = var = (Var)i$.next();
            ++i2;
        }
        return vars;
    }

    ReifiedAllSConstraint(IntDomainVar bool, AbstractSConstraint cons, Solver solver) {
        this(bool, cons, cons.opposite(solver));
    }

    ReifiedAllSConstraint(IntDomainVar bool, AbstractSConstraint cons, AbstractSConstraint oppositeCons) {
        super(ReifiedAllSConstraint.makeTableVar(bool, cons, oppositeCons));
        this.cons = cons;
        this.oppositeCons = oppositeCons;
        this.bool = bool;
    }

    @Override
    public final void addExtension(int extensionNumber) {
        super.addExtension(extensionNumber);
        Extension ext = this.extensions[extensionNumber];
        this.cons.setExtension(ext, extensionNumber);
        this.oppositeCons.setExtension(ext, extensionNumber);
    }

    public final void filterReifiedConstraintFromBool() throws ContradictionException {
        if (this.bool.isInstantiatedTo(1)) {
            this.cons.awake();
        } else {
            this.oppositeCons.awake();
        }
    }

    public void filterReifiedConstraintFromCons() throws ContradictionException {
        Boolean isEntailed = this.cons.isEntailed();
        if (isEntailed != null) {
            if (isEntailed.booleanValue()) {
                this.bool.instantiate(1, this, false);
            } else {
                this.bool.instantiate(0, this, true);
            }
        }
    }

    public final void filter() throws ContradictionException {
        if (this.vars[0].isInstantiated()) {
            this.filterReifiedConstraintFromBool();
        } else {
            this.filterReifiedConstraintFromCons();
        }
    }

    @Override
    public final void propagate() throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInf(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnSup(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnRem(int varIdx, int val) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnRemovals(int varIdx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnBounds(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnKer(int varIdx, int x) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnEnv(int varIdx, int x) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnInst(int varIdx) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnkerAdditions(int sIdx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public void awakeOnEnvRemovals(int sIdx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter();
    }

    @Override
    public final boolean isConsistent() {
        return Boolean.TRUE.equals(this.isEntailed());
    }

    public final void addListener(AbstractSConstraint thecons) {
        if (thecons instanceof ReifiedAllSConstraint) {
            ReifiedAllSConstraint rcons = (ReifiedAllSConstraint)thecons;
            this.addListener(rcons.cons);
            this.addListener(rcons.oppositeCons);
        }
        int n = thecons.getNbVars();
        for (int i = 0; i < n; ++i) {
            thecons.setConstraintIndex(i, this.getIndex((AbstractVar)thecons.getVar(i)));
        }
    }

    public final int getIndex(AbstractVar v) {
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.vars[i] != v) continue;
            return this.cIndices[i];
        }
        return -1;
    }

    @Override
    public final void addListener(boolean dynamicAddition) {
        super.addListener(dynamicAddition);
        this.addListener(this.cons);
        this.addListener(this.oppositeCons);
    }

    @Override
    public final void setPropagationEngine(PropagationEngine propEng) {
        super.setPropagationEngine(propEng);
        this.cons.setPropagationEngine(propEng);
        this.oppositeCons.setPropagationEngine(propEng);
    }

    @Override
    public final String pretty() {
        StringBuilder sb = new StringBuilder("(");
        sb.append(" 1");
        sb.append("<=>").append(this.cons.pretty());
        if (this.oppositeCons != null) {
            sb.append(" -- 0");
            sb.append("<=>").append(this.oppositeCons.pretty());
        }
        sb.append(')');
        sb.append('~').append(this.vars[0].pretty());
        return sb.toString();
    }

    @Override
    public boolean isSatisfied() {
        if (this.isCompletelyInstantiated()) {
            if (this.bool.isInstantiatedTo(1)) {
                return this.cons.isSatisfied();
            }
            return this.oppositeCons.isSatisfied();
        }
        return false;
    }

    @Override
    public SConstraintType getConstraintType() {
        return SConstraintType.MIXED;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        throw new UnsupportedOperationException(this + " needs to implement isSatisfied(int[] tuple) to be embedded in reified constraints");
    }
}

