/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.filtering.structuralFiltering;

import choco.cp.solver.constraints.global.tree.filtering.AbstractPropagator;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.Vector;

public class Nproper
extends AbstractPropagator {
    protected int lowerBd = this.getLowerBound();
    protected int upperBd;
    protected IStateBitSet tmp;

    public Nproper(Object[] params) {
        super(params);
        IStateBitSet potentialRoots = this.inputGraph.getPotentialRoots();
        this.upperBd = this.getUpperBound(potentialRoots);
        this.tmp = this.solver.getEnvironment().makeBitSet(this.nbVertices);
    }

    @Override
    public String getTypePropag() {
        return "Nproper progagation";
    }

    @Override
    public boolean feasibility() throws ContradictionException {
        if (this.tree.getNtree().getSup() < this.tree.getNproper().getSup()) {
            if (this.affiche) {
                LOGGER.info("1-NProper: updateSup nProper = " + this.tree.getNproper().getSup() + " ==> " + this.tree.getNtree().getSup());
            }
            this.propagateStruct.setMaxNProper(this.tree.getNtree().getSup());
        }
        if (this.tree.getNtree().getInf() < this.tree.getNproper().getInf()) {
            if (this.affiche) {
                LOGGER.info("1-NProper: updateInf nProper = " + this.tree.getNproper().getInf() + " ==> " + this.tree.getNtree().getInf());
            }
            this.propagateStruct.setMinNProper(this.tree.getNtree().getInf());
        }
        this.lowerBd = this.getLowerBound();
        if (this.lowerBd > this.tree.getNproper().getInf()) {
            if (this.affiche) {
                LOGGER.info("2-NProper: updateInf nProper = " + this.tree.getNproper().getInf() + " ==> " + this.lowerBd);
            }
            this.propagateStruct.setMinNProper(this.lowerBd);
        }
        IStateBitSet potentialRoots = this.inputGraph.getPotentialRoots();
        this.upperBd = this.getUpperBound(potentialRoots);
        if (this.upperBd < this.tree.getNproper().getSup()) {
            if (this.affiche) {
                LOGGER.info("2-NProper: updateSup nProper = " + this.tree.getNproper().getSup() + " ==> " + this.upperBd);
            }
            this.propagateStruct.setMaxNProper(this.upperBd);
        }
        Vector<IStateBitSet> setcc = this.inputGraph.getSure().getSetCC();
        int nprop_build = 0;
        for (IStateBitSet aSetcc : setcc) {
            if (aSetcc.cardinality() <= 1) continue;
            ++nprop_build;
        }
        if (nprop_build < this.lowerBd) {
            if (this.affiche) {
                LOGGER.info("nprop_build = " + nprop_build + " VS nProper.getSup = " + this.lowerBd);
            }
            return false;
        }
        return true;
    }

    @Override
    public void filter() {
        int j;
        if (this.tree.getNproper().getSup() <= this.lowerBd) {
            this.tmp.clear();
            Vector<IStateBitSet> ccOfGt = this.inputGraph.getSure().getSetCC();
            for (IStateBitSet aCcOfGt : ccOfGt) {
                if (aCcOfGt.cardinality() < 2) continue;
                int j2 = aCcOfGt.nextSetBit(0);
                while (j2 >= 0) {
                    this.tmp.set(j2, true);
                    j2 = aCcOfGt.nextSetBit(j2 + 1);
                }
            }
            Vector<IStateBitSet> ccOfGp = this.precs.getPrecs().getSetCC();
            for (IStateBitSet aCcOfGp : ccOfGp) {
                if (aCcOfGp.cardinality() < 2) continue;
                j = aCcOfGp.nextSetBit(0);
                while (j >= 0) {
                    this.tmp.set(j, true);
                    j = aCcOfGp.nextSetBit(j + 1);
                }
            }
            if (this.tmp.cardinality() >= 2) {
                for (int i = 0; i < this.nbVertices; ++i) {
                    int[] arc;
                    int j3;
                    IntDomainVar var = this.nodes[i].getSuccessors();
                    boolean reachable = false;
                    int j4 = this.tmp.nextSetBit(0);
                    while (j4 >= 0) {
                        if (this.inputGraph.getMaybe().getSuccessors(i).get(j4)) {
                            reachable = true;
                        }
                        j4 = this.tmp.nextSetBit(j4 + 1);
                    }
                    if (this.tmp.get(i) || reachable) continue;
                    DisposableIntIterator it = var.getDomain().getIterator();
                    while (it.hasNext()) {
                        j3 = it.next();
                        if (j3 == i || !var.canBeInstantiatedTo(j3)) continue;
                        if (this.affiche) {
                            LOGGER.info("1-1 NProper: suppression arc (" + i + "," + j3 + ")");
                        }
                        arc = new int[]{i, j3};
                        this.propagateStruct.addRemoval(arc);
                    }
                    it.dispose();
                    for (j3 = 0; j3 < this.nbVertices; ++j3) {
                        if (j3 == i || !this.nodes[j3].getSuccessors().canBeInstantiatedTo(i)) continue;
                        if (this.affiche) {
                            LOGGER.info("1-2 NProper: suppression arc (" + j3 + "," + i + ")");
                        }
                        arc = new int[]{j3, i};
                        this.propagateStruct.addRemoval(arc);
                    }
                }
            }
        }
        IStateBitSet potentialRoots = this.inputGraph.getPotentialRoots();
        if (this.tree.getNproper().getInf() >= this.upperBd) {
            int i = potentialRoots.nextSetBit(0);
            while (i >= 0) {
                IntDomainVar var = this.nodes[i].getSuccessors();
                DisposableIntIterator it = var.getDomain().getIterator();
                while (it.hasNext()) {
                    j = it.next();
                    if (j == i || !var.canBeInstantiatedTo(j)) continue;
                    if (this.affiche) {
                        LOGGER.info("2- NProper: suppression arc (" + i + "," + j + ")");
                    }
                    int[] arc = new int[]{i, j};
                    this.propagateStruct.addRemoval(arc);
                }
                it.dispose();
                i = potentialRoots.nextSetBit(i + 1);
            }
        }
    }

    private int getUpperBound(IStateBitSet potentialRoots) {
        int nbPotRoots = potentialRoots.cardinality();
        int nbIsolatedRoots = 0;
        for (int i = 0; i < this.nbVertices; ++i) {
            int nbReached = 0;
            for (int j = 0; j < this.nbVertices; ++j) {
                if (!this.nodes[j].getSuccessors().canBeInstantiatedTo(i) || i == j) continue;
                ++nbReached;
            }
            if (nbReached != 0 || !this.nodes[i].getSuccessors().isInstantiatedTo(i)) continue;
            ++nbIsolatedRoots;
        }
        return nbPotRoots - nbIsolatedRoots;
    }

    private int getLowerBound() {
        int val = 0;
        Vector<IStateBitSet> ccOfGt = this.inputGraph.getSure().getSetCC();
        for (IStateBitSet aCcOfGt : ccOfGt) {
            if (aCcOfGt.cardinality() < 2) continue;
            boolean root = false;
            int j = aCcOfGt.nextSetBit(0);
            while (j >= 0) {
                if (this.nodes[j].getSuccessors().isInstantiatedTo(j)) {
                    root = true;
                }
                j = aCcOfGt.nextSetBit(j + 1);
            }
            if (!root) continue;
            ++val;
        }
        return val;
    }
}

