/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.configure;

import choco.cp.solver.configure.RestartFactory;
import choco.cp.solver.search.SearchLimitManager;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.Solver;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.limit.AbstractGlobalSearchLimit;
import choco.kernel.solver.search.limit.BackTrackLimit;
import choco.kernel.solver.search.limit.FailLimit;
import choco.kernel.solver.search.limit.Limit;
import choco.kernel.solver.search.limit.NodeLimit;
import choco.kernel.solver.search.limit.RestartLimit;
import choco.kernel.solver.search.limit.TimeLimit;

public final class LimitFactory {
    private LimitFactory() {
    }

    public static final void setSearchLimit(Configuration conf, Limit type, int limitBound) {
        conf.putEnum("cp.search.limit.type", type);
        conf.putInt("cp.search.limit.value", limitBound);
    }

    public static final void setSearchLimit(Solver solver, Limit type, int limitBound) {
        LimitFactory.setSearchLimit(solver.getConfiguration(), type, limitBound);
    }

    public static final AbstractGlobalSearchLimit makeSearchLimit(AbstractGlobalSearchStrategy strategy) {
        Configuration conf = strategy.solver.getConfiguration();
        Limit lim = (Limit)((Object)conf.readEnum("cp.search.limit.type", Limit.class));
        return LimitFactory.makeLimit(strategy, lim, conf.readInt("cp.search.limit.value"));
    }

    public static final void setRestartLimit(Configuration conf, Limit type, int limitBound) {
        conf.putEnum("cp.restart.limit.type", type);
        conf.putInt("cp.restart.limit.value", limitBound);
    }

    public static final void setRestartLimit(Solver solver, Limit type, int limitBound) {
        LimitFactory.setRestartLimit(solver.getConfiguration(), type, limitBound);
    }

    public static final AbstractGlobalSearchLimit makeRestartLimit(AbstractGlobalSearchStrategy strategy) {
        Configuration conf = strategy.solver.getConfiguration();
        Limit lim = (Limit)((Object)conf.readEnum("cp.restart.limit.type", Limit.class));
        return LimitFactory.makeLimit(strategy, lim, conf.readInt("cp.restart.limit.value"));
    }

    public static final AbstractGlobalSearchLimit createLimit(AbstractGlobalSearchStrategy strategy, Limit type, int theLimit) {
        switch (type) {
            case TIME: {
                return new TimeLimit(strategy, theLimit);
            }
            case NODE: {
                return new NodeLimit(strategy, theLimit);
            }
            case BACKTRACK: {
                return new BackTrackLimit(strategy, theLimit);
            }
            case RESTART: {
                return new RestartLimit(strategy, theLimit);
            }
            case FAIL: {
                strategy.solver.monitorFailLimit(true);
                return new FailLimit(strategy, theLimit);
            }
        }
        return null;
    }

    private static Limit getPolicyLimit(Solver solver) {
        return (Limit)((Object)solver.getConfiguration().readEnum("cp.restart.policy.limit.type", Limit.class));
    }

    public static final SearchLimitManager createLimitManager(AbstractGlobalSearchStrategy strategy) {
        SearchLimitManager limitManager = new SearchLimitManager(strategy);
        limitManager.setSearchLimit(LimitFactory.makeSearchLimit(strategy));
        limitManager.setRestartLimit(LimitFactory.makeRestartLimit(strategy));
        limitManager.setRestartStrategy(RestartFactory.createRestartStrategy(strategy.solver), LimitFactory.createLimit(strategy, LimitFactory.getPolicyLimit(strategy.solver), Integer.MAX_VALUE));
        return limitManager;
    }

    public static final AbstractGlobalSearchLimit makeLimit(AbstractGlobalSearchStrategy strategy, Limit type, int theLimit) {
        if (strategy != null && type != null && theLimit != Integer.MAX_VALUE) {
            return LimitFactory.createLimit(strategy, type, theLimit);
        }
        return null;
    }
}

