// (c) The HDF Group
#ifndef H5Zdevelop_H
#define H5Zdevelop_H
#include "H5Zpublic.h"
#define H5Z_CLASS_T_VERS (1)
typedef struct H5Z_cb_t {
    H5Z_filter_func_t func;
    void             *op_data;
} H5Z_cb_t;
//! <!-- [H5Z_can_apply_func_t_snip] -->
typedef htri_t (*H5Z_can_apply_func_t)(hid_t dcpl_id, hid_t type_id, hid_t space_id);
//! <!-- [H5Z_can_apply_func_t_snip] -->
//! <!-- [H5Z_set_local_func_t_snip] -->
typedef herr_t (*H5Z_set_local_func_t)(hid_t dcpl_id, hid_t type_id, hid_t space_id);
//! <!-- [H5Z_set_local_func_t_snip] -->
//! <!-- [H5Z_func_t_snip] -->
typedef size_t (*H5Z_func_t)(unsigned int flags, size_t cd_nelmts, const unsigned int cd_values[],
                             size_t nbytes, size_t *buf_size, void **buf);
//! <!-- [H5Z_func_t_snip] -->
//! <!-- [H5Z_class2_t_snip] -->
typedef struct H5Z_class2_t {
    int                  version;
    H5Z_filter_t         id;
    unsigned             encoder_present;
    unsigned             decoder_present;
    const char          *name;
    H5Z_can_apply_func_t can_apply;
    H5Z_set_local_func_t set_local;
    H5Z_func_t           filter;
} H5Z_class2_t;
//! <!-- [H5Z_class2_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Zregister(const void *cls);
H5_DLL herr_t H5Zunregister(H5Z_filter_t id);
#ifdef __cplusplus
}
#endif
#ifndef H5_NO_DEPRECATED_SYMBOLS
//! <!-- [H5Z_class1_t_snip] -->
typedef struct H5Z_class1_t {
    H5Z_filter_t         id;
    const char          *name;
    H5Z_can_apply_func_t can_apply;
    H5Z_set_local_func_t set_local;
    H5Z_func_t           filter;
} H5Z_class1_t;
//! <!-- [H5Z_class1_t_snip] -->
#endif
#endif
