// (c) The HDF Group
#ifndef H5FDsplitter_H
#define H5FDsplitter_H
#define H5FD_SPLITTER (H5FDperform_init(H5FD_splitter_init))
#define H5FD_SPLITTER_VALUE H5_VFD_SPLITTER
#define H5FD_CURR_SPLITTER_VFD_CONFIG_VERSION 1
#define H5FD_SPLITTER_PATH_MAX 4096
#define H5FD_SPLITTER_MAGIC 0x2B916880
//! <!-- [H5FD_splitter_vfd_config_t_snip] -->
typedef struct H5FD_splitter_vfd_config_t {
    int32_t      magic;
    unsigned int version;
    hid_t rw_fapl_id;
    hid_t wo_fapl_id;
    char wo_path[H5FD_SPLITTER_PATH_MAX + 1];
    char log_file_path[H5FD_SPLITTER_PATH_MAX + 1];
    hbool_t ignore_wo_errs;
} H5FD_splitter_vfd_config_t;
//! <!-- [H5FD_splitter_vfd_config_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_splitter_init(void);
H5_DLL herr_t H5Pset_fapl_splitter(hid_t fapl_id, H5FD_splitter_vfd_config_t *config_ptr);
H5_DLL herr_t H5Pget_fapl_splitter(hid_t fapl_id, H5FD_splitter_vfd_config_t *config_ptr);
#ifdef __cplusplus
}
#endif
#endif
