/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public class TerminatingBlocksFinder
implements BoilerpipeFilter {
    public static final TerminatingBlocksFinder INSTANCE = new TerminatingBlocksFinder();

    public static TerminatingBlocksFinder getInstance() {
        return INSTANCE;
    }

    public boolean process(TextDocument doc) throws BoilerpipeProcessingException {
        boolean changes = false;
        for (TextBlock tb : doc.getTextBlocks()) {
            String textLC;
            String text;
            int len;
            int numWords = tb.getNumWords();
            if (numWords >= 15 || (len = (text = tb.getText().trim()).length()) < 8 || !(textLC = text.toLowerCase()).startsWith("comments") && !TerminatingBlocksFinder.startsWithNumber(textLC, len, " comments", " users responded in") && !textLC.startsWith("\u00a9 reuters") && !textLC.startsWith("please rate this") && !textLC.startsWith("post a comment") && !textLC.contains("what you think...") && !textLC.contains("add your comment") && !textLC.contains("add comment") && !textLC.contains("reader views") && !textLC.contains("have your say") && !textLC.contains("reader comments") && !textLC.contains("r\u00e4tta artikeln") && !textLC.equals("thanks for your comments - this feedback is now closed")) continue;
            tb.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
            changes = true;
        }
        return changes;
    }

    private static boolean startsWithNumber(String t, int len, String ... str) {
        int j;
        for (j = 0; j < len && TerminatingBlocksFinder.isDigit(t.charAt(j)); ++j) {
        }
        if (j != 0) {
            for (String s : str) {
                if (!t.startsWith(s, j)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

