## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
# Calculate intervals for N = 10, and IV = 30
N <- 12
VI <- 30

intervals <- round(fleshler_hoffman(N, VI), 3)
print(intervals)

## ----echo = FALSE-------------------------------------------------------------
plot(x = intervals, y = 1:length(intervals))
hist(intervals, freq = F)
curve(dexp(x, rate = 1 / VI), add = TRUE, col = "red")
legend("topright", legend = c("F&H", "Exponential"), lty = 1, col = c("black", "red"))

