/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.SVM.SMO.core;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import keel.Algorithms.SVM.SMO.core.ClassDiscovery;

public class SerializationHelper {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static boolean isSerializable(String classname) {
        boolean result;
        try {
            result = SerializationHelper.isSerializable(Class.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean isSerializable(Class c) {
        return ClassDiscovery.hasInterface(Serializable.class, c);
    }

    public static boolean hasUID(String classname) {
        boolean result;
        try {
            result = SerializationHelper.hasUID(Class.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean hasUID(Class c) {
        boolean result = false;
        if (SerializationHelper.isSerializable(c)) {
            try {
                c.getDeclaredField(SERIAL_VERSION_UID);
                result = true;
            }
            catch (Exception e) {
                result = false;
            }
        }
        return result;
    }

    public static boolean needsUID(String classname) {
        boolean result;
        try {
            result = SerializationHelper.needsUID(Class.forName(classname));
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean needsUID(Class c) {
        boolean result = SerializationHelper.isSerializable(c) ? !SerializationHelper.hasUID(c) : false;
        return result;
    }

    public static long getUID(String classname) {
        long result;
        try {
            result = SerializationHelper.getUID(Class.forName(classname));
        }
        catch (Exception e) {
            result = 0L;
        }
        return result;
    }

    public static long getUID(Class c) {
        return ObjectStreamClass.lookup(c).getSerialVersionUID();
    }

    public static void write(String filename, Object o) throws Exception {
        SerializationHelper.write(new FileOutputStream(filename), o);
    }

    public static void write(OutputStream stream, Object o) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(stream);
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    public static Object read(String filename) throws Exception {
        return SerializationHelper.read(new FileInputStream(filename));
    }

    public static Object read(InputStream stream) throws Exception {
        ObjectInputStream ois = new ObjectInputStream(stream);
        Object result = ois.readObject();
        ois.close();
        return result;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("\nUsage: " + SerializationHelper.class.getName() + " classname [classname [classname [...]]]\n");
            System.exit(1);
        }
        System.out.println();
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            System.out.println("- is serializable: " + SerializationHelper.isSerializable(args[i]));
            System.out.println("- has serialVersionUID: " + SerializationHelper.hasUID(args[i]));
            System.out.println("- needs serialVersionUID: " + SerializationHelper.needsUID(args[i]));
            System.out.println("- serialVersionUID: private static final long serialVersionUID = " + SerializationHelper.getUID(args[i]) + "L;");
            System.out.println();
        }
    }
}

