/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.BaseR;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.Difuso;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Thrift.TipoIntervalo;

class BaseD {
    Difuso[][] BaseDatos;
    int n_variables;
    int n_var_estado;
    int[] n_etiquetas;
    public TipoIntervalo[] extremos;

    public BaseD(int MaxEtiquetas, int n_var, double[][] _extremos) {
        int i;
        this.n_variables = n_var;
        this.n_var_estado = this.n_variables - 1;
        this.BaseDatos = new Difuso[this.n_variables][MaxEtiquetas];
        for (i = 0; i < this.n_variables; ++i) {
            this.BaseDatos[i] = new Difuso[MaxEtiquetas];
            for (int j = 0; j < MaxEtiquetas; ++j) {
                this.BaseDatos[i][j] = new Difuso();
            }
        }
        this.n_etiquetas = new int[this.n_variables];
        this.extremos = new TipoIntervalo[this.n_variables];
        for (i = 0; i < this.n_variables; ++i) {
            this.extremos[i] = new TipoIntervalo();
            this.extremos[i].min = _extremos[i][0];
            this.extremos[i].max = _extremos[i][1];
            this.n_etiquetas[i] = MaxEtiquetas;
        }
    }

    public double Asigna(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }

    public void Semantica() {
        for (int var = 0; var < this.n_variables; ++var) {
            double marca = (this.extremos[var].max - this.extremos[var].min) / ((double)this.n_etiquetas[var] - 1.0);
            for (int etq = 0; etq < this.n_etiquetas[var]; ++etq) {
                double valor = this.extremos[var].min + marca * (double)(etq - 1);
                this.BaseDatos[var][etq].x0 = this.Asigna(valor, this.extremos[var].max);
                valor = this.extremos[var].min + marca * (double)etq;
                this.BaseDatos[var][etq].x2 = this.BaseDatos[var][etq].x1 = this.Asigna(valor, this.extremos[var].max);
                valor = this.extremos[var].min + marca * (double)(etq + 1);
                this.BaseDatos[var][etq].x3 = this.Asigna(valor, this.extremos[var].max);
                this.BaseDatos[var][etq].y = 1.0;
                this.BaseDatos[var][etq].Nombre = "V" + (var + 1);
                this.BaseDatos[var][etq].Etiqueta = "E" + (etq + 1);
            }
        }
    }

    public int getnLabels(int i) {
        return this.n_etiquetas[i];
    }

    public Difuso getParticion(int i, int j) {
        return this.BaseDatos[i][j].copia();
    }

    public double AntecedenteCubreEjemplo(int[] AntRegla, double[] ejem) {
        int i;
        double[] grado_pertenencia = new double[this.n_var_estado];
        for (i = 0; i < this.n_var_estado; ++i) {
            grado_pertenencia[i] = BaseR.Fuzzifica(ejem[i], this.getParticion(i, AntRegla[i]));
        }
        double min = 1.0;
        for (i = 0; i < this.n_var_estado; ++i) {
            if (!(grado_pertenencia[i] < min)) continue;
            min = grado_pertenencia[i];
        }
        return min;
    }

    public double getExtremoInf(int var) {
        return this.extremos[var].min;
    }

    public double getExtremoSup(int var) {
        return this.extremos[var].max;
    }

    public String printString() {
        String cadena = new String("");
        for (int i = 0; i < this.n_variables; ++i) {
            cadena = cadena + "\nVariable " + (i + 1) + ":\n";
            for (int j = 0; j < this.n_etiquetas[i]; ++j) {
                cadena = cadena + " Etiqueta " + (j + 1) + ": (" + this.BaseDatos[i][j].x0 + "," + this.BaseDatos[i][j].x1 + "," + this.BaseDatos[i][j].x3 + ")\n";
            }
        }
        return cadena;
    }
}

