/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.util.normalizer;

import keel.Algorithms.Neural_Networks.NNEP_Common.data.DoubleTransposedDataSet;

public class Normalizer {
    public void scaleDS(DoubleTransposedDataSet dataset, double[] scaledMax, double[] scaledMin, double[] unscaledMax, double[] unscaledMin) {
        for (int i = 0; i < dataset.getNofvariables(); ++i) {
            double[] observations = dataset.getObservationsOf(i);
            this.scale(observations, unscaledMax[i], unscaledMin[i], scaledMax[i], scaledMin[i]);
        }
        dataset.calculateMeans();
    }

    public void scale(double[] values, double unscaledMax, double unscaledMin, double scaledMax, double scaledMin) {
        double coefficient = unscaledMax == unscaledMin ? 0.0 : (scaledMax - scaledMin) / (unscaledMax - unscaledMin);
        for (int i = 0; i < values.length; ++i) {
            values[i] = coefficient * (values[i] - unscaledMin) + scaledMin;
        }
    }

    public double scale(double value, double unscaledMax, double unscaledMin, double scaledMax, double scaledMin) {
        double coefficient = unscaledMax == unscaledMin ? 0.0 : (scaledMax - scaledMin) / (unscaledMax - unscaledMin);
        return coefficient * (value - unscaledMin) + scaledMin;
    }
}

