/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms;

import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Algorithms.GeneticAlgorithm;
import keel.Algorithms.Fuzzy_Rule_Learning.Genetic.Shared.Individual.GeneticIndividual;
import keel.Algorithms.Shared.Exceptions.invalidFitness;
import keel.Algorithms.Shared.Exceptions.invalidMutation;
import keel.Algorithms.Shared.Exceptions.invalidOptim;
import org.core.Randomize;

public class SimulatedAnnealing
extends GeneticAlgorithm {
    static Randomize rand;
    double fitnessC;
    double fitnessC1;
    double fitnessCBest;
    double delta;
    double v;
    double T;
    double T0;
    double T1;
    double P0;
    double P1;
    GeneticIndividual C;
    GeneticIndividual CBest;
    double GAMUTATIONPROB;
    double LOCALOPTPROB;
    int LOCALOPTITER;
    int GAMUTATIONID;
    int GPMUTATIONID;
    int NSUB;
    double K1;
    double Km;
    double df;
    int LOID;

    public SimulatedAnnealing(GeneticIndividual initialIndividual, double pPROBMUTAGA, double deltaFit, double p0, double p1, double KM, int pNSUB, Randomize r, int pGAMutationID, int pGPMutationID, int pNUMOL, int pIDOL, double pLOptProb) {
        this.fitnessCBest = this.fitnessC;
        rand = r;
        this.P0 = p0;
        this.P1 = p1;
        this.GAMUTATIONPROB = pPROBMUTAGA;
        this.NSUB = pNSUB;
        this.T0 = -deltaFit / Math.log(p0);
        this.T1 = -deltaFit / Math.log(p1);
        System.out.println("Initial Temeperature=" + this.T0);
        System.out.println("Final Temperature=" + this.T1);
        this.K1 = 2.0 * (this.T0 + this.T1) / KM;
        this.Km = KM;
        this.C = initialIndividual.clone();
        this.C.Random();
        this.CBest = this.C.clone();
        this.GAMUTATIONID = pGAMutationID;
        this.GPMUTATIONID = pGPMutationID;
        this.df = deltaFit;
        this.LOCALOPTITER = pNUMOL;
        this.LOID = pIDOL;
        this.LOCALOPTPROB = pLOptProb;
        try {
            this.fitnessCBest = this.fitnessC = this.C.fitness();
        }
        catch (invalidFitness e) {
            System.out.println("Unsupported fitness function");
        }
    }

    @Override
    public GeneticIndividual evolve(int MAXITER) throws invalidMutation, invalidOptim {
        boolean adaptative = false;
        System.out.println("Local Optimization method: " + this.LOCALOPTPROB + " " + this.LOCALOPTITER);
        System.out.println("Number of iterations=" + MAXITER + " * " + this.NSUB);
        double CoolingFactor = Math.exp(1.0 / (double)MAXITER * Math.log(this.T1 / this.T0));
        System.out.println("Cooling Factor=" + CoolingFactor);
        this.T = this.T0;
        double allowedMean = 0.0;
        double deviationMean = 0.0;
        try {
            double allowed = 0.0;
            double deltaMean = 0.0;
            for (int it = 0; it < MAXITER; ++it) {
                allowed = 0.0;
                deltaMean = 0.0;
                for (int sub = 0; sub < this.NSUB; ++sub) {
                    GeneticIndividual C1;
                    block12: {
                        block13: {
                            C1 = this.C.clone();
                            if (rand.Rand() < this.GAMUTATIONPROB) {
                                C1.mutation(this.T / this.K1, this.GAMUTATIONID);
                            } else {
                                C1.mutation(0.0, this.GPMUTATIONID);
                            }
                            this.fitnessC1 = C1.fitness();
                            this.delta = this.fitnessC1 - this.fitnessC;
                            if (!(this.LOCALOPTPROB > 0.0)) break block12;
                            if (this.delta < 0.0) break block13;
                            if (!(rand.Rand() < this.LOCALOPTPROB)) break block12;
                        }
                        C1.localOptimization(this.LOCALOPTITER, this.LOID);
                    }
                    this.v = rand.Rand();
                    double edt = Math.exp(-this.delta / this.T);
                    if (this.delta > 0.0 && this.v < edt) {
                        allowed += 1.0;
                    }
                    if (this.delta > 0.0) {
                        deltaMean += this.delta;
                    }
                    if (!(this.delta < 0.0) && !(this.v < edt)) continue;
                    this.C = C1.clone();
                    this.fitnessC = this.fitnessC1;
                    if (!(this.fitnessC1 < this.fitnessCBest)) continue;
                    this.CBest = C1.clone();
                    this.fitnessCBest = this.fitnessC1;
                }
                double temperatureDeviation = this.P0 + (double)it * (this.P1 - this.P0) / (double)MAXITER;
                double errorintegral = (deviationMean += temperatureDeviation) - (allowedMean += (allowed /= (double)this.NSUB));
                double Kregul = 1.0;
                double correccion = Math.exp(Kregul * errorintegral);
                System.out.println("Iteration=" + it + ", the best fitness=" + this.fitnessCBest + ", the current fitness=" + this.fitnessC + ", allowable fr.=" + allowed + ", fitness mean increasing=" + (deltaMean /= (double)this.NSUB) + ", current probability factor=" + temperatureDeviation + ", integral error=" + errorintegral + ", current Temperature=" + this.T);
                this.T *= CoolingFactor;
            }
            System.out.println("Local Optimizacion of final result: ");
            if (this.LOCALOPTPROB > 0.0) {
                this.CBest.localOptimization(this.LOCALOPTITER, this.LOID);
            }
            System.out.println("Final Fitness value=" + this.CBest.fitness());
        }
        catch (invalidFitness e) {
            System.out.println("Unsupported fitness function");
        }
        return this.CBest.clone();
    }
}

