/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.ISystem;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class MultiMutator
implements IMutator,
IConfigure {
    private static final long serialVersionUID = -6300502786816813015L;
    protected IMutator[] components;
    protected transient ISystem context;

    public MultiMutator() {
    }

    public MultiMutator(ISystem context) {
        this.contextualize(context);
    }

    public final IMutator[] getComponents() {
        return this.components;
    }

    public final void setComponents(IMutator[] components) {
        this.components = components;
        if (this.context != null) {
            IMutator[] iMutatorArray = components;
            int n = components.length;
            int n2 = 0;
            while (n2 < n) {
                IMutator component = iMutatorArray[n2];
                component.contextualize(this.context);
                ++n2;
            }
        }
    }

    @Override
    public void contextualize(ISystem context) {
        this.context = context;
        if (this.components != null) {
            IMutator[] iMutatorArray = this.components;
            int n = this.components.length;
            int n2 = 0;
            while (n2 < n) {
                IMutator component = iMutatorArray[n2];
                component.contextualize(context);
                ++n2;
            }
        }
    }

    @Override
    public List<IIndividual> mutate(List<IIndividual> parents) {
        ArrayList<IIndividual> result = new ArrayList<IIndividual>();
        IMutator[] iMutatorArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            IMutator component = iMutatorArray[n2];
            result.addAll(component.mutate(parents));
            ++n2;
        }
        return result;
    }

    @Override
    public void configure(Configuration settings) {
        int numberOfComponents = settings.getList("component[@type]").size();
        IMutator[] components = new IMutator[numberOfComponents];
        int i = 0;
        while (i < numberOfComponents) {
            String header = "component(" + i + ")";
            try {
                String componentClassname = settings.getString(String.valueOf(header) + "[@type");
                Class<?> componentClass = Class.forName(componentClassname);
                IMutator component = (IMutator)componentClass.newInstance();
                if (component instanceof IConfigure) {
                    ((IConfigure)((Object)component)).configure(settings.subset(header));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.setComponents(components);
    }

    public boolean equals(Object other) {
        if (other instanceof MultiMutator) {
            MultiMutator o = (MultiMutator)other;
            int cl = this.components.length;
            if (cl == o.components.length) {
                EqualsBuilder eb = new EqualsBuilder();
                int i = 0;
                while (i < cl) {
                    eb.append(this.components[i], o.components[i]);
                    ++i;
                }
                return eb.isEquals();
            }
            return false;
        }
        return false;
    }
}

