/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.algorithm.classic;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.IIndividual;
import net.sourceforge.jclec.IMutator;
import net.sourceforge.jclec.IRecombinator;
import net.sourceforge.jclec.ISelector;
import net.sourceforge.jclec.algorithm.PopulationAlgorithm;
import net.sourceforge.jclec.base.FilteredMutator;
import net.sourceforge.jclec.base.FilteredRecombinator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.lang.builder.EqualsBuilder;

public class SG
extends PopulationAlgorithm {
    private static final long serialVersionUID = -2649346083463795286L;
    protected ISelector parentsSelector;
    protected FilteredMutator mutator;
    protected FilteredRecombinator recombinator;

    public ISelector getParentsSelector() {
        return this.parentsSelector;
    }

    public void setParentsSelector(ISelector parentsSelector) {
        this.parentsSelector = parentsSelector;
        parentsSelector.contextualize(this);
    }

    public IRecombinator getRecombinator() {
        return this.recombinator.getDecorated();
    }

    public void setRecombinator(IRecombinator recombinator) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setDecorated(recombinator);
    }

    public double getRecombinationProb() {
        return this.recombinator.getRecProb();
    }

    public void setRecombinationProb(double recProb) {
        if (this.recombinator == null) {
            this.recombinator = new FilteredRecombinator(this);
        }
        this.recombinator.setRecProb(recProb);
    }

    public IMutator getMutator() {
        return this.mutator.getDecorated();
    }

    public void setMutator(IMutator mutator) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setDecorated(mutator);
    }

    public double getMutationProb() {
        return this.mutator.getMutProb();
    }

    public void setMutationProb(double mutProb) {
        if (this.mutator == null) {
            this.mutator = new FilteredMutator(this);
        }
        this.mutator.setMutProb(mutProb);
    }

    @Override
    public void configure(Configuration configuration) {
        super.configure(configuration);
        try {
            String parentsSelectorClassname = configuration.getString("parents-selector[@type]");
            Class<?> parentsSelectorClass = Class.forName(parentsSelectorClassname);
            ISelector parentsSelector = (ISelector)parentsSelectorClass.newInstance();
            if (parentsSelector instanceof IConfigure) {
                Configuration parentsSelectorConfiguration = configuration.subset("parents-selector");
                ((IConfigure)((Object)parentsSelector)).configure(parentsSelectorConfiguration);
            }
            this.setParentsSelector(parentsSelector);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal parents selector classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of parents selector", e);
        }
        try {
            String recombinatorClassname = configuration.getString("recombinator[@type]");
            Class<?> recombinatorClass = Class.forName(recombinatorClassname);
            IRecombinator recombinator = (IRecombinator)recombinatorClass.newInstance();
            if (recombinator instanceof IConfigure) {
                Configuration recombinatorConfiguration = configuration.subset("recombinator");
                ((IConfigure)((Object)recombinator)).configure(recombinatorConfiguration);
            }
            this.setRecombinator(recombinator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal recombinator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of recombinator", e);
        }
        double recProb = configuration.getDouble("recombinator[@rec-prob]");
        this.setRecombinationProb(recProb);
        try {
            String mutatorClassname = configuration.getString("mutator[@type]");
            Class<?> mutatorClass = Class.forName(mutatorClassname);
            IMutator mutator = (IMutator)mutatorClass.newInstance();
            if (mutator instanceof IConfigure) {
                Configuration mutatorConfiguration = configuration.subset("mutator");
                ((IConfigure)((Object)mutator)).configure(mutatorConfiguration);
            }
            this.setMutator(mutator);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal mutator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of mutator", e);
        }
        double mutProb = configuration.getDouble("mutator[@mut-prob]");
        this.setMutationProb(mutProb);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof SG) {
            SG cother = (SG)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.appendSuper(super.equals(other));
            eb.append(this.parentsSelector, cother.parentsSelector);
            eb.append(this.mutator, cother.mutator);
            eb.append(this.recombinator, cother.recombinator);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected void doSelection() {
        this.pset = this.parentsSelector.select(this.bset);
    }

    @Override
    protected void doGeneration() {
        this.cset = this.recombinator.recombine(this.pset);
        for (IIndividual ind : this.recombinator.getSterile()) {
            this.cset.add(ind.copy());
        }
        this.cset = this.mutator.mutate(this.cset);
        for (IIndividual ind : this.mutator.getSterile()) {
            this.cset.add(ind);
        }
        this.evaluator.evaluate(this.cset);
    }

    @Override
    protected void doReplacement() {
        this.rset = this.bset;
    }

    @Override
    protected void doUpdate() {
        this.bset = this.cset;
        this.pset = null;
        this.rset = null;
        this.cset = null;
    }
}

