/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v30;

import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class AvailabilityParser
implements Parser<Map<String, List<String>>> {
    private static final String sourceClass = AvailabilityParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String KEYVAL = "KeyValue";
    static final String ID = "id";
    static final String VALUE = "Value";

    @Override
    public Map<String, List<String>> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        return AvailabilityParser.parse(xMLEventReader, list, KEYVAL, ID, VALUE);
    }

    public static Map<String, List<String>> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list, String string, String string2, String string3) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        ArrayList<String> arrayList = null;
        String string4 = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (string.equals(object.getName().getLocalPart())) {
                    arrayList = new ArrayList<String>();
                    Iterator<Attribute> iterator = object.getAttributes();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!string2.equals(attribute.getName().getLocalPart())) continue;
                        string4 = attribute.getValue();
                    }
                } else if (string3.equals(object.getName().getLocalPart())) {
                    arrayList.add(xMLEventReader.getElementText());
                }
            }
            if (!xMLEvent.isEndElement() || !string.equals(object = xMLEvent.asEndElement().getName().getLocalPart())) continue;
            if (string4 != null) {
                if (string4.equals("TIME_PERIOD")) continue;
                if (arrayList.size() > 0) {
                    logger.finer("Got dimension " + string4);
                    linkedHashMap.put(string4, arrayList);
                    continue;
                }
                throw new SdmxInvalidParameterException("The selection identifies an empty cube region");
            }
            throw new SdmxXmlContentException("Error during Codelist Parsing. Invalid dimension");
        }
        return linkedHashMap;
    }
}

