/*
 * Decompiled with CFR 0.152.
 */
package javalain.algorithmegenetique.gene;

import java.text.DecimalFormat;
import javalain.algorithmegenetique.DomaineReel;
import javalain.algorithmegenetique.Gene;
import javalain.algorithmegenetique.gene.Entier;
import javalain.ea.operator.Mutator;
import javalain.math.PseudoRandomNumbers;
import util.GuiUtils;

public final class ReelDouble
extends Gene {
    private static DecimalFormat DF = GuiUtils.DECIMAL_3;
    private DomaineReel interv;
    private double valeur;
    private type_mutation mutation;

    public ReelDouble(DomaineReel i) {
        this.interv = i;
        this.valeur = PseudoRandomNumbers.random() * this.interv.getTaille() + this.interv.getMin();
        this.mutation = type_mutation.MUTATION_PERSO;
    }

    private ReelDouble(DomaineReel i, double d) {
        this.interv = i;
        this.valeur = d;
        this.mutation = type_mutation.MUTATION_PERSO;
    }

    public void set(double d) {
        if (!(this.interv.getMin() <= d) || !(d <= this.interv.getMax())) {
            throw new IllegalArgumentException("ReelDouble, set (double d) : le nombre n'appartient pas \u00e0 l'intervalle de definition.");
        }
        this.valeur = d;
    }

    public double get() {
        return this.valeur;
    }

    public DomaineReel getIntervalle() {
        return this.interv;
    }

    public static void setDecimalFormat(DecimalFormat df) {
        DF = df;
    }

    @Override
    public Gene melanger(Gene g) {
        switch ((int)(PseudoRandomNumbers.random() * 3.0)) {
            case 0: {
                return new ReelDouble(this.interv, this.valeur);
            }
            case 1: {
                return new ReelDouble(((ReelDouble)g).interv, ((ReelDouble)g).valeur);
            }
        }
        double x = PseudoRandomNumbers.random() * 1.5 - 0.25;
        double y = x * this.valeur + (1.0 - x) * ((ReelDouble)g).valeur;
        if (y > this.interv.getMax()) {
            y = this.interv.getMax();
        }
        if (y < this.interv.getMin()) {
            y = this.interv.getMin();
        }
        return new ReelDouble(this.interv, y);
    }

    @Override
    public void mutation() {
        if (this.mutation == type_mutation.MUTATION_PERSO) {
            switch ((int)(PseudoRandomNumbers.random() * 3.0)) {
                case 0: {
                    this.valeur += PseudoRandomNumbers.random() * Math.min(this.interv.getRayon(), this.interv.getMax() - this.valeur);
                    break;
                }
                case 1: {
                    this.valeur -= PseudoRandomNumbers.random() * Math.min(this.interv.getRayon(), this.valeur - this.interv.getMin());
                    break;
                }
                default: {
                    this.valeur = PseudoRandomNumbers.random() * this.interv.getTaille() + this.interv.getMin();
                    break;
                }
            }
        } else {
            this.valeur = Mutator.mutationPolynomiale(0.05, this.valeur, this.interv.getMin(), this.interv.getMax(), 20.0);
        }
    }

    @Override
    public Gene copier() {
        return new ReelDouble(this.interv, this.valeur);
    }

    @Override
    public Gene creer() {
        return new ReelDouble(this.interv);
    }

    @Override
    public boolean estEgalA(Gene g) {
        if (g instanceof ReelDouble) {
            return this.valeur == ((ReelDouble)g).valeur;
        }
        if (g instanceof Entier) {
            return this.valeur == (double)((Entier)g).get();
        }
        return false;
    }

    @Override
    public StringBuilder afficher() {
        return new StringBuilder().append(DF.format(this.valeur));
    }

    public static enum type_mutation {
        MUTATION_PERSO,
        MUTATION_POLYNOMIALE;

    }
}

