/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.GradientProvider;
import dr.math.UnivariateFunction;
import dr.math.distributions.Distribution;
import org.apache.commons.math.util.FastMath;

public class CauchyDistribution
implements Distribution,
GradientProvider {
    private final double median;
    private final double scale;
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public double evaluate(double d) {
            return CauchyDistribution.this.pdf(d);
        }

        @Override
        public double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };

    public CauchyDistribution(double d, double d2) {
        this.median = d;
        this.scale = d2;
    }

    public static double pdf(double d, double d2, double d3) {
        double d4 = d - d2;
        return d3 / (d4 * d4 + d3 * d3) / Math.PI;
    }

    public static double cdf(double d, double d2, double d3) {
        return 0.5 + FastMath.atan((d - d2) / d3) / Math.PI;
    }

    public static double quantile(double d, double d2, double d3) {
        if (!(d < 0.0) && !(d > 1.0)) {
            double d4 = d == 0.0 ? Double.NEGATIVE_INFINITY : (d == 1.0 ? Double.POSITIVE_INFINITY : d2 + d3 * FastMath.tan(Math.PI * (d - 0.5)));
            return d4;
        }
        throw new IllegalArgumentException("Out of range");
    }

    public static double gradLogPdf(double d, double d2, double d3) {
        double d4 = d - d2;
        return -2.0 * d4 / (d4 * d4 + d3 * d3);
    }

    public static double logPdf(double d, double d2, double d3) {
        return Math.log(CauchyDistribution.pdf(d, d2, d3));
    }

    @Override
    public double pdf(double d) {
        return CauchyDistribution.pdf(d, this.median, this.scale);
    }

    @Override
    public double logPdf(double d) {
        return CauchyDistribution.logPdf(d, this.median, this.scale);
    }

    @Override
    public double cdf(double d) {
        return CauchyDistribution.cdf(d, this.median, this.scale);
    }

    @Override
    public double quantile(double d) {
        return CauchyDistribution.quantile(d, this.median, this.scale);
    }

    @Override
    public double mean() {
        return Double.NaN;
    }

    @Override
    public double variance() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double d = (Double)object;
        return new double[]{CauchyDistribution.gradLogPdf(d, this.median, this.scale)};
    }
}

