/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.discrete;

import dr.evolution.tree.MutableTreeModel;
import dr.evomodel.tree.TreeChangedEvent;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.tree.TreeParameterModel;
import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class NodeHeightProxyParameter
extends Parameter.Proxy {
    private TreeModel tree;
    private TreeParameterModel indexHelper;
    private static final String NODE_HEIGHT_PARAMETER = "nodeHeightProxyParameter";
    private static final String INCLUDE_ROOT = "rootNode";
    public static AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = xMLObject.getBooleanAttribute(NodeHeightProxyParameter.INCLUDE_ROOT);
            TreeModel treeModel = (TreeModel)xMLObject.getChild(TreeModel.class);
            return new NodeHeightProxyParameter(NodeHeightProxyParameter.NODE_HEIGHT_PARAMETER, treeModel, bl);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newBooleanRule(NodeHeightProxyParameter.INCLUDE_ROOT), new ElementRule(TreeModel.class)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return NodeHeightProxyParameter.class;
        }

        @Override
        public String getParserName() {
            return NodeHeightProxyParameter.NODE_HEIGHT_PARAMETER;
        }
    };

    public NodeHeightProxyParameter(String string, TreeModel treeModel, boolean bl) {
        super(string, bl ? treeModel.getInternalNodeCount() : treeModel.getInternalNodeCount() - 1);
        this.tree = treeModel;
        this.indexHelper = new TreeParameterModel((MutableTreeModel)treeModel, (Parameter)new Parameter.Default(bl ? treeModel.getInternalNodeCount() : treeModel.getInternalNodeCount() - 1, 0.0), bl);
    }

    @Override
    public Bounds<Double> getBounds() {
        return null;
    }

    public TreeModel getTree() {
        return this.tree;
    }

    private int getNodeNumber(int n) {
        return this.indexHelper.getNodeNumberFromParameterIndex(n + this.tree.getExternalNodeCount());
    }

    @Override
    public double getParameterValue(int n) {
        return this.tree.getNodeHeight(this.tree.getNode(this.getNodeNumber(n)));
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.tree.setNodeHeight(this.tree.getNode(this.getNodeNumber(n)), d);
        this.tree.pushTreeChangedEvent(this.tree.getNode(this.getNodeNumber(n)));
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.tree.setNodeHeightQuietly(this.tree.getNode(this.getNodeNumber(n)), d);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getParameterValue(0)));
        Object var2_2 = null;
        for (int i = 1; i < this.getDimension(); ++i) {
            stringBuilder.append("\t").append(String.valueOf(this.getParameterValue(i)));
        }
        return stringBuilder.toString();
    }

    @Override
    public void fireParameterChangedEvent() {
        this.tree.pushTreeChangedEvent(TreeChangedEvent.create(true, true));
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.setParameterValue(n, d);
    }
}

