/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.Worker;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ShutdownFuture
implements Future<Void> {
    private static final Log log = LogFactory.getLog(ShutdownFuture.class);
    private final CountDownLatch shutdownCompleteLatch;
    private final CountDownLatch notificationCompleteLatch;
    private final Worker worker;

    ShutdownFuture(CountDownLatch shutdownCompleteLatch, CountDownLatch notificationCompleteLatch, Worker worker) {
        this.shutdownCompleteLatch = shutdownCompleteLatch;
        this.notificationCompleteLatch = notificationCompleteLatch;
        this.worker = worker;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Cannot cancel a shutdown process");
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.isWorkerShutdownComplete();
    }

    private boolean isWorkerShutdownComplete() {
        return this.worker.isShutdownComplete() || this.worker.getShardInfoShardConsumerMap().isEmpty();
    }

    private long outstandingRecordProcessors(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long startNanos = System.nanoTime();
        if (!this.notificationCompleteLatch.await(timeout, unit)) {
            long awaitingNotification = this.notificationCompleteLatch.getCount();
            long awaitingFinalShutdown = this.shutdownCompleteLatch.getCount();
            log.info((Object)("Awaiting " + awaitingNotification + " record processors to complete shutdown notification, and " + awaitingFinalShutdown + " awaiting final shutdown"));
            if (awaitingFinalShutdown != 0L) {
                return this.checkWorkerShutdownMiss(awaitingFinalShutdown);
            }
        }
        long remaining = this.remainingTimeout(timeout, unit, startNanos);
        this.throwTimeoutMessageIfExceeded(remaining, "Notification hasn't completed within timeout time.");
        this.worker.shutdown();
        remaining = this.remainingTimeout(timeout, unit, startNanos);
        this.throwTimeoutMessageIfExceeded(remaining, "Shutdown hasn't completed within timeout time.");
        if (!this.shutdownCompleteLatch.await(remaining, TimeUnit.NANOSECONDS)) {
            long outstanding = this.shutdownCompleteLatch.getCount();
            log.info((Object)("Awaiting " + outstanding + " record processors to complete final shutdown"));
            return this.checkWorkerShutdownMiss(outstanding);
        }
        return 0L;
    }

    private long remainingTimeout(long timeout, TimeUnit unit, long startNanos) {
        long checkNanos = System.nanoTime() - startNanos;
        return unit.toNanos(timeout) - checkNanos;
    }

    private void throwTimeoutMessageIfExceeded(long remainingNanos, String message) throws TimeoutException {
        if (remainingNanos <= 0L) {
            throw new TimeoutException(message);
        }
    }

    private long checkWorkerShutdownMiss(long outstanding) {
        if (this.isWorkerShutdownComplete()) {
            if (outstanding != 0L) {
                log.info((Object)("Shutdown completed, but shutdownCompleteLatch still had outstanding " + outstanding + " with a current value of " + this.shutdownCompleteLatch.getCount() + ". shutdownComplete: " + this.worker.isShutdownComplete() + " -- Consumer Map: " + this.worker.getShardInfoShardConsumerMap().size()));
            }
            return 0L;
        }
        return outstanding;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        boolean complete = false;
        do {
            try {
                long outstanding = this.outstandingRecordProcessors(1L, TimeUnit.SECONDS);
                complete = outstanding == 0L;
                log.info((Object)("Awaiting " + outstanding + " consumer(s) to finish shutdown."));
            }
            catch (TimeoutException te) {
                log.info((Object)("Timeout while waiting for completion: " + te.getMessage()));
            }
        } while (!complete);
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long outstanding = this.outstandingRecordProcessors(timeout, unit);
        if (outstanding != 0L) {
            throw new TimeoutException("Awaiting " + outstanding + " record processors to shutdown.");
        }
        return null;
    }
}

