/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.iterators;

import choco.kernel.common.util.disposable.PoolManager;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.IStored;

public final class IntArrayIterator
extends DisposableIntIterator
implements IStored {
    private static final ThreadLocal<PoolManager<IntArrayIterator>> manager = new ThreadLocal();
    private int[] elements;
    private int endIdx;
    private int curentIdx;
    private boolean isStored;

    private IntArrayIterator() {
    }

    public static IntArrayIterator getIterator(int[] someElements, int from, int to) {
        IntArrayIterator it;
        PoolManager<IntArrayIterator> tmanager = manager.get();
        if (tmanager == null) {
            tmanager = new PoolManager();
            manager.set(tmanager);
        }
        if ((it = tmanager.getE()) == null) {
            it = new IntArrayIterator();
        }
        it.init(someElements, from, to);
        return it;
    }

    public void init(int[] someElements, int from, int to) {
        super.init();
        this.elements = someElements;
        this.endIdx = to;
        this.curentIdx = from;
    }

    @Override
    public boolean hasNext() {
        return this.curentIdx < this.endIdx;
    }

    @Override
    public int next() {
        return this.elements[this.curentIdx++];
    }

    @Override
    public void dispose() {
        super.dispose();
        manager.get().returnE(this);
    }

    @Override
    public void push() {
        this.isStored = true;
    }

    @Override
    public void pop() {
        this.isStored = false;
    }

    @Override
    public boolean isStored() {
        return this.isStored;
    }
}

