/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_multicostregular;

import choco.kernel.common.Constant;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.model.constraints.automaton.FA.CostAutomaton;
import choco.kernel.model.constraints.automaton.FA.IAutomaton;
import choco.kernel.model.constraints.automaton.FA.ICostAutomaton;
import choco.kernel.model.constraints.automaton.FA.utils.Bounds;
import choco.kernel.model.constraints.automaton.FA.utils.ICounter;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.automata.common.StoredIndexedBipartiteSetWithOffset;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.algo.FastPathFinder;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.Arc;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.Node;
import choco.kernel.solver.constraints.global.automata.fast_multicostregular.structure.StoredDirectedMultiGraph;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import gnu.trove.TIntStack;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.jgrapht.graph.DirectedMultigraph;

public final class MultiCostRegular
extends AbstractLargeIntSConstraint {
    public static int MAXBOUNDITER = 10;
    public static int MAXNONIMPROVEITER = 15;
    public static double U0 = 10.0;
    public static double RO = 0.7;
    public final TObjectIntHashMap<IntDomainVar> map;
    public int[] lastSp;
    public double lastSpValue;
    public int[] lastLp;
    public double lastLpValue;
    protected final IntDomainVar[] vs;
    public final IntDomainVar[] z;
    protected ICostAutomaton pi;
    protected StoredDirectedMultiGraph graph;
    protected final boolean[] modifiedBound;
    protected final double[] uUb;
    protected final double[] uLb;
    protected FastPathFinder slp;
    protected final int nbR;
    protected final TIntStack toRemove;
    protected final TIntStack[] toUpdateLeft;
    protected final TIntStack[] toUpdateRight;
    protected final TIntHashSet removed = new TIntHashSet();
    private final IEnvironment environment;
    private final Solver solver;
    public int lastWorld = -1;
    public int lastNbOfBacktracks = -1;
    public int lastNbOfRestarts = -1;
    private TIntHashSet boundUpdate;
    private boolean computed;

    private MultiCostRegular(IntDomainVar[] vars, IntDomainVar[] counterVars, Solver solver) {
        super(ConstraintEvent.VERY_SLOW, ArrayUtils.append(vars, counterVars));
        int i;
        this.environment = solver.getEnvironment();
        this.solver = solver;
        this.vs = vars;
        this.z = counterVars;
        this.nbR = this.z.length - 1;
        this.modifiedBound = new boolean[]{true, true};
        this.uUb = new double[2 * this.nbR];
        this.uLb = new double[2 * this.nbR];
        this.map = new TObjectIntHashMap();
        for (i = 0; i < vars.length; ++i) {
            this.map.put(vars[i], i);
        }
        this.toRemove = new TIntStack();
        this.toUpdateLeft = new TIntStack[this.nbR + 1];
        this.toUpdateRight = new TIntStack[this.nbR + 1];
        for (i = 0; i <= this.nbR; ++i) {
            this.toUpdateLeft[i] = new TIntStack();
            this.toUpdateRight[i] = new TIntStack();
        }
        this.boundUpdate = new TIntHashSet();
    }

    public MultiCostRegular(IntDomainVar[] vars, IntDomainVar[] CR, IAutomaton auto, int[][][] costs, Solver solver) {
        this(vars, CR, solver);
        this.pi = CostAutomaton.makeMultiResources(auto, costs, CR);
    }

    public MultiCostRegular(IntDomainVar[] vars, IntDomainVar[] CR, IAutomaton auto, int[][][][] costs, Solver solver) {
        this(vars, CR, solver);
        this.pi = CostAutomaton.makeMultiResources(auto, costs, CR);
    }

    public MultiCostRegular(IntDomainVar[] vars, IntDomainVar[] CR, ICostAutomaton pi, Solver solver) {
        this(vars, CR, solver);
        this.pi = pi;
    }

    public void initGraph() {
        int k;
        TIntIterator layerIter;
        int j;
        DisposableIntIterator varIter;
        int i;
        int aid = 0;
        int nid = 0;
        int[] offsets = new int[this.vs.length];
        int[] sizes = new int[this.vs.length];
        int[] starts = new int[this.vs.length];
        int totalSizes = 0;
        starts[0] = 0;
        for (int i2 = 0; i2 < this.vs.length; ++i2) {
            offsets[i2] = this.vs[i2].getInf();
            sizes[i2] = this.vs[i2].getSup() - this.vs[i2].getInf() + 1;
            if (i2 > 0) {
                starts[i2] = sizes[i2 - 1] + starts[i2 - 1];
            }
            totalSizes += sizes[i2];
        }
        int n = this.vs.length;
        DirectedMultigraph<Node, Arc> graph = new DirectedMultigraph<Node, Arc>(new Arc.ArcFacroty());
        ArrayList tmp = new ArrayList(totalSizes);
        for (i = 0; i < totalSizes; ++i) {
            tmp.add(new HashSet());
        }
        ArrayList<TIntHashSet> layer = new ArrayList<TIntHashSet>();
        TIntHashSet[] tmpQ = new TIntHashSet[totalSizes];
        for (i = 0; i <= n; ++i) {
            layer.add(new TIntHashSet());
        }
        ((TIntHashSet)layer.get(0)).add(this.pi.getInitialState());
        TIntHashSet nexts = new TIntHashSet();
        for (i = 0; i < n; ++i) {
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                layerIter = ((TIntHashSet)layer.get(i)).iterator();
                while (layerIter.hasNext()) {
                    k = layerIter.next();
                    nexts.clear();
                    this.pi.delta(k, j, nexts);
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        int succ = it.next();
                        ((TIntHashSet)layer.get(i + 1)).add(succ);
                    }
                    if (nexts.isEmpty()) continue;
                    int idx = starts[i] + j - offsets[i];
                    if (tmpQ[idx] == null) {
                        tmpQ[idx] = new TIntHashSet();
                    }
                    tmpQ[idx].add(k);
                }
            }
            varIter.dispose();
        }
        layerIter = ((TIntHashSet)layer.get(n)).iterator();
        while (layerIter.hasNext()) {
            k = layerIter.next();
            if (this.pi.isFinal(k)) continue;
            layerIter.remove();
        }
        int nbNodes = this.pi.getNbStates();
        BitSet mark = new BitSet(nbNodes);
        Node[] in = new Node[this.pi.getNbStates() * (n + 1)];
        Node tink = new Node(this.pi.getNbStates() + 1, n + 1, nid++);
        graph.addVertex(tink);
        for (i = n - 1; i >= 0; --i) {
            mark.clear(0, nbNodes);
            varIter = this.vs[i].getDomain().getIterator();
            while (varIter.hasNext()) {
                j = varIter.next();
                int idx = starts[i] + j - offsets[i];
                TIntHashSet l = tmpQ[idx];
                if (l == null) continue;
                TIntIterator qijIter = l.iterator();
                while (qijIter.hasNext()) {
                    k = qijIter.next();
                    nexts.clear();
                    this.pi.delta(k, j, nexts);
                    if (nexts.size() > 1) {
                        System.err.println("STOP");
                    }
                    boolean added = false;
                    TIntIterator it = nexts.iterator();
                    while (it.hasNext()) {
                        Node b;
                        int qn = it.next();
                        if (!((TIntHashSet)layer.get(i + 1)).contains(qn)) continue;
                        added = true;
                        Node a = in[i * this.pi.getNbStates() + k];
                        if (a == null) {
                            in[i * this.pi.getNbStates() + k] = a = new Node(k, i, nid++);
                            graph.addVertex(a);
                        }
                        if ((b = in[(i + 1) * this.pi.getNbStates() + qn]) == null) {
                            in[(i + 1) * this.pi.getNbStates() + qn] = b = new Node(qn, i + 1, nid++);
                            graph.addVertex(b);
                        }
                        Arc arc = new Arc(a, b, j, aid++);
                        graph.addEdge(a, b, arc);
                        ((HashSet)tmp.get(idx)).add(arc);
                        mark.set(k);
                    }
                    if (added) continue;
                    qijIter.remove();
                }
            }
            varIter.dispose();
            layerIter = ((TIntHashSet)layer.get(i)).iterator();
            while (layerIter.hasNext()) {
                if (mark.get(layerIter.next())) continue;
                layerIter.remove();
            }
        }
        TIntHashSet th = new TIntHashSet();
        int[][] intLayer = new int[n + 2][];
        for (k = 0; k < this.pi.getNbStates(); ++k) {
            Node o = in[n * this.pi.getNbStates() + k];
            if (o == null) continue;
            Arc a = new Arc(o, tink, 0, aid++);
            graph.addEdge(o, tink, a);
        }
        for (i = 0; i <= n; ++i) {
            th.clear();
            for (k = 0; k < this.pi.getNbStates(); ++k) {
                Node o = in[i * this.pi.getNbStates() + k];
                if (o == null) continue;
                th.add(o.id);
            }
            intLayer[i] = th.toArray();
        }
        intLayer[n + 1] = new int[]{tink.id};
        if (intLayer[0].length > 0) {
            this.graph = new StoredDirectedMultiGraph(this.environment, this, graph, intLayer, starts, offsets, totalSizes, this.pi, this.z);
            this.graph.makePathFinder();
        }
    }

    protected void updateUpperBound() throws ContradictionException {
        int[] P;
        double lp;
        double coeff;
        boolean modif;
        int k = 0;
        double bk = RO;
        int nbNSig = 0;
        int nbNSig2 = 0;
        double bestVal = Double.POSITIVE_INFINITY;
        do {
            coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uUb[i] * (double)this.z[i + 1].getSup();
                coeff -= this.uUb[i + this.nbR] * (double)this.z[i + 1].getInf();
            }
            modif = false;
            this.slp.computeLongestPath(this.toRemove, (double)this.z[0].getInf() - coeff, this.uUb, true, true, 0);
            lp = this.slp.getLongestPathValue();
            P = this.slp.getLongestPath();
            this.filterUp(lp + coeff);
            if (bestVal - (lp + coeff) < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (lp + coeff < bestVal) {
                bestVal = lp + coeff;
            }
            double uk = U0 * Math.pow(bk, k);
            for (int l = 0; l < this.uUb.length / 2; ++l) {
                double axu = 0.0;
                for (int e : P) {
                    int i = this.graph.GNodes.layers[this.graph.GArcs.origs[e]];
                    if (i >= this.vs.length) continue;
                    axu += this.graph.GArcs.originalCost[e][l + 1];
                }
                double newLB = Math.max(this.uUb[l] - uk * ((double)this.z[l + 1].getSup() - axu), 0.0);
                double newLA = Math.max(this.uUb[l + this.nbR] - uk * (axu - (double)this.z[l + 1].getInf()), 0.0);
                if (Math.abs(this.uUb[l] - newLB) >= Constant.MCR_DECIMAL_PREC) {
                    this.uUb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uUb[l + this.nbR] - newLA) >= Constant.MCR_DECIMAL_PREC)) continue;
                this.uUb[l + this.nbR] = newLA;
                modif = true;
            }
        } while (modif && nbNSig2 < MAXNONIMPROVEITER && ++k < MAXBOUNDITER);
        this.lastLp = P;
        this.lastLpValue = lp + coeff;
    }

    protected void updateLowerBound() throws ContradictionException {
        boolean modif;
        int k = 0;
        double bk = RO;
        double bestVal = Double.NEGATIVE_INFINITY;
        int nbNSig = 0;
        int nbNSig2 = 0;
        int[] bestPath = new int[this.vs.length + 1];
        do {
            double coeff = 0.0;
            for (int i = 0; i < this.nbR; ++i) {
                coeff += this.uLb[i] * (double)this.z[i + 1].getSup();
                coeff -= this.uLb[i + this.nbR] * (double)this.z[i + 1].getInf();
            }
            modif = false;
            this.slp.computeShortestPath(this.toRemove, (double)this.z[0].getSup() + coeff, this.uLb, true, false, 0);
            double sp = this.slp.getShortestPathValue();
            int[] P = this.slp.getShortestPath();
            this.filterDown(sp - coeff);
            if (sp - coeff - bestVal < 0.5) {
                ++nbNSig;
                ++nbNSig2;
            } else {
                nbNSig = 0;
                nbNSig2 = 0;
            }
            if (nbNSig == 3) {
                bk *= 0.8;
                nbNSig = 0;
            }
            if (sp - coeff > bestVal) {
                bestVal = sp - coeff;
                System.arraycopy(P, 0, bestPath, 0, P.length);
            }
            double uk = U0 * Math.pow(bk, k);
            for (int l = 0; l < this.uLb.length / 2; ++l) {
                double axu = 0.0;
                for (int e : P) {
                    int i = this.graph.GNodes.layers[this.graph.GArcs.origs[e]];
                    if (i >= this.vs.length) continue;
                    axu += this.graph.GArcs.originalCost[e][l + 1];
                }
                double newLB = Math.max(this.uLb[l] + uk * (axu - (double)this.z[l + 1].getSup()), 0.0);
                double newLA = Math.max(this.uLb[l + this.nbR] + uk * ((double)this.z[l + 1].getInf() - axu), 0.0);
                if (Math.abs(this.uLb[l] - newLB) >= Constant.MCR_DECIMAL_PREC) {
                    this.uLb[l] = newLB;
                    modif = true;
                }
                if (!(Math.abs(this.uLb[l + this.nbR] - newLA) >= Constant.MCR_DECIMAL_PREC)) continue;
                this.uLb[l + this.nbR] = newLA;
                modif = true;
            }
        } while (modif && nbNSig2 < MAXNONIMPROVEITER && ++k < MAXBOUNDITER);
        this.lastSp = bestPath;
        this.lastSpValue = bestVal;
    }

    protected boolean prefilter() throws ContradictionException {
        FastPathFinder p = this.graph.getPathFinder();
        boolean cont = true;
        while (cont) {
            boolean[] modified = p.computeShortestAndLongestPath(this.toRemove, this.z);
            cont = this.toRemove.size() > 0;
            this.modifiedBound[0] = this.modifiedBound[0] | modified[0];
            this.modifiedBound[1] = this.modifiedBound[1] | modified[1];
            this.delayedGraphUpdate();
        }
        return this.modifiedBound[0] || this.modifiedBound[1];
    }

    protected void filterDown(double realsp) throws ContradictionException {
        if (realsp - (double)this.z[0].getSup() >= Constant.MCR_DECIMAL_PREC) {
            this.fail();
        }
        if (realsp - (double)this.z[0].getInf() >= Constant.MCR_DECIMAL_PREC) {
            double mr = Math.round(realsp);
            double rsp = realsp - mr <= Constant.MCR_DECIMAL_PREC ? mr : realsp;
            this.z[0].updateInf((int)Math.ceil(rsp), this, false);
            this.modifiedBound[0] = true;
        }
    }

    protected void filterUp(double reallp) throws ContradictionException {
        if (reallp - (double)this.z[0].getInf() <= -Constant.MCR_DECIMAL_PREC) {
            this.fail();
        }
        if (reallp - (double)this.z[0].getSup() <= -Constant.MCR_DECIMAL_PREC) {
            double mr = Math.round(reallp);
            double rsp = reallp - mr <= Constant.MCR_DECIMAL_PREC ? mr : reallp;
            this.z[0].updateSup((int)Math.floor(rsp), this, false);
            this.modifiedBound[1] = true;
        }
    }

    protected void checkWorld() throws ContradictionException {
        int currentworld = this.environment.getWorldIndex();
        int currentbt = this.solver.getBackTrackCount();
        int currentrestart = this.solver.getRestartCount();
        if (currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts) {
            for (int i = 0; i <= this.nbR; ++i) {
                this.toUpdateLeft[i].reset();
                this.toUpdateRight[i].reset();
            }
            this.toRemove.reset();
            this.graph.inStack.clear();
            this.getGraph().getPathFinder().computeShortestAndLongestPath(this.toRemove, this.z);
            this.computed = true;
        }
        this.lastWorld = currentworld;
        this.lastNbOfBacktracks = currentbt;
        this.lastNbOfRestarts = currentrestart;
    }

    protected void delayedGraphUpdate() throws ContradictionException {
        boolean needUpdate = false;
        try {
            while (true) {
                if (this.toRemove.size() > 0) {
                    int n = this.toRemove.pop();
                    needUpdate = this.graph.removeArc(n, this.toRemove, this.toUpdateLeft, this.toUpdateRight);
                    continue;
                }
                for (int k = 0; k <= this.nbR; ++k) {
                    while (this.toUpdateLeft[k].size() > 0) {
                        this.graph.updateLeft(this.toUpdateLeft[k], this.toRemove, k, this.modifiedBound);
                        if (this.toRemove.size() <= 0) continue;
                    }
                    while (this.toUpdateRight[k].size() > 0) {
                        this.graph.updateRight(this.toUpdateRight[k], this.toRemove, k, this.modifiedBound);
                        if (this.toRemove.size() <= 0) continue;
                    }
                }
                if (this.toRemove.size() <= 0) break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void computeSharpBounds() throws ContradictionException {
        while (this.modifiedBound[0] || this.modifiedBound[1]) {
            if (this.modifiedBound[1]) {
                this.modifiedBound[1] = false;
                this.updateLowerBound();
            }
            if (this.modifiedBound[0]) {
                this.modifiedBound[0] = false;
                this.updateUpperBound();
            }
            this.delayedGraphUpdate();
        }
    }

    private boolean remContains(int e) {
        int[] element = this.toRemove.toNativeArray();
        for (int i = 0; i < this.toRemove.size(); ++i) {
            if (element[i] != e) continue;
            return true;
        }
        return false;
    }

    @Override
    public void awakeOnRem(int idx, int val) throws ContradictionException {
        this.checkWorld();
        StoredIndexedBipartiteSetWithOffset support = this.graph.getSupport(idx, val);
        if (support != null) {
            int[] list = support._getStructure();
            int size = support.size();
            for (int i = 0; i < size; ++i) {
                int e = list[i];
                assert (this.graph.isInStack(e) == this.remContains(e));
                if (this.graph.isInStack(e)) continue;
                this.graph.setInStack(e);
                this.toRemove.push(e);
            }
            if (this.toRemove.size() > 0) {
                this.constAwake(false);
            }
        }
    }

    @Override
    public final void awakeOnInst(int idx) {
        this.boundChange(idx);
    }

    @Override
    public final void awakeOnSup(int idx) {
        this.boundChange(idx);
    }

    @Override
    public final void awakeOnInf(int idx) {
        this.boundChange(idx);
    }

    public void boundChange(int idx) {
        this.boundUpdate.add(idx - this.vs.length);
        this.computed = false;
        this.constAwake(false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.checkBounds();
        this.initGraph();
        if (this.graph == null) {
            this.fail();
        }
        this.slp = this.graph.getPathFinder();
        for (int i = 0; i < this.vs.length; ++i) {
            int right = Integer.MIN_VALUE;
            int left = Integer.MIN_VALUE;
            int j = this.vs[i].getInf();
            while (j <= this.vs[i].getSup()) {
                StoredIndexedBipartiteSetWithOffset sup = this.graph.getSupport(i, j);
                if (sup == null || sup.isEmpty()) {
                    if (j == right + 1) {
                        right = j;
                    } else {
                        this.vs[i].removeInterval(left, right, this, false);
                        left = right = j;
                    }
                }
                j = this.vs[i].getNextDomainValue(j);
            }
            this.vs[i].removeInterval(left, right, this, false);
        }
        this.slp.computeShortestAndLongestPath(this.toRemove, this.z);
        this.propagate();
    }

    private void checkBounds() throws ContradictionException {
        List<ICounter> counters = this.pi.getCounters();
        int nbCounters = this.pi.getNbResources();
        for (int i = 0; i < nbCounters; ++i) {
            IntDomainVar z = this.z[i];
            Bounds bounds = counters.get(i).bounds();
            z.updateInf(bounds.min.value, this, false);
            z.updateSup(bounds.max.value, this, false);
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        this.checkWorld();
        this.delayedBoundUpdate();
        this.delayedGraphUpdate();
        this.modifiedBound[0] = true;
        this.modifiedBound[1] = true;
        this.computeSharpBounds();
        assert (this.toRemove.size() == 0);
        assert (this.check());
        assert (this.isGraphConsistent());
    }

    private void delayedBoundUpdate() throws ContradictionException {
        if (!this.computed && this.boundUpdate.size() > 0) {
            this.getGraph().delayedBoundUpdate(this.toRemove, this.z, this.boundUpdate.toArray());
            this.boundUpdate.clear();
        }
    }

    public void rebuildCostRegInfo() throws ContradictionException {
        this.checkWorld();
    }

    public final boolean needPropagation() {
        int currentworld = this.environment.getWorldIndex();
        int currentbt = this.solver.getBackTrackCount();
        int currentrestart = this.solver.getRestartCount();
        return currentworld < this.lastWorld || currentbt != this.lastNbOfBacktracks || currentrestart > this.lastNbOfRestarts;
    }

    public boolean isGraphConsistent() {
        boolean ret = true;
        for (int i = 0; i < this.vs.length; ++i) {
            DisposableIntIterator iter = this.graph.layers[i].getIterator();
            while (iter.hasNext()) {
                int n = iter.next();
                DisposableIntIterator it = this.graph.GNodes.outArcs[n].getIterator();
                while (it.hasNext()) {
                    int arc = it.next();
                    int val = this.graph.GArcs.values[arc];
                    if (((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(val)) continue;
                    System.err.println("Arc " + arc + " from node " + n + " to node" + this.graph.GArcs.dests[arc] + " with value " + val + " in layer " + i + " should not be here");
                    return false;
                }
            }
            iter.dispose();
        }
        return ret;
    }

    public final StoredDirectedMultiGraph getGraph() {
        return this.graph;
    }

    public final int getRegret(int layer, int value, int ... resources) {
        return this.graph.getRegret(layer, value, resources);
    }

    @Override
    public boolean isSatisfied() {
        for (IntDomainVar var : (IntDomainVar[])this.vars) {
            if (var.isInstantiated()) continue;
            return false;
        }
        return this.check();
    }

    @Override
    public boolean isSatisfied(int[] word) {
        int[] first = new int[this.vs.length];
        System.arraycopy(word, 0, first, 0, first.length);
        return this.check(first);
    }

    public boolean check(int[] word) {
        if (!this.pi.run(word)) {
            System.err.println("Word is not accepted by the automaton");
            System.err.print("{" + word[0]);
            for (int i = 1; i < word.length; ++i) {
                System.err.print("," + word[i]);
            }
            System.err.println("}");
            return false;
        }
        int[] gcost = new int[this.z.length];
        for (int l = 0; l < this.graph.layers.length - 2; ++l) {
            DisposableIntIterator it = this.graph.layers[l].getIterator();
            while (it.hasNext()) {
                int orig = it.next();
                DisposableIntIterator arcIter = this.graph.GNodes.outArcs[orig].getIterator();
                while (arcIter.hasNext()) {
                    int arc = arcIter.next();
                    for (int i = 0; i < this.z.length; ++i) {
                        int n = i;
                        gcost[n] = (int)((double)gcost[n] + this.graph.GArcs.originalCost[arc][i]);
                    }
                }
                arcIter.dispose();
            }
            it.dispose();
        }
        for (int i = 0; i < gcost.length; ++i) {
            if (!this.z[i].isInstantiated()) {
                LOGGER.severe("Error, z[" + i + "] in MCR should be instantiated : " + this.z[i]);
                return false;
            }
            if (this.z[i].getVal() == gcost[i]) continue;
            LOGGER.severe("cost: " + gcost[i] + " != z:" + this.z[i].getVal());
            return false;
        }
        return true;
    }

    public boolean check() {
        int[] word = new int[this.vs.length];
        for (int i = 0; i < this.vs.length; ++i) {
            if (!this.vs[i].isInstantiated()) {
                return true;
            }
            word[i] = this.vs[i].getVal();
        }
        for (IntDomainVar aZ : this.z) {
            if (aZ.isInstantiated()) continue;
            return true;
        }
        return this.check(word);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return idx < this.vs.length ? 4 : 11;
    }

    public int getMinPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinPathCostForAssignment(col, val, resources);
    }

    public int[] getMinMaxPathCostForAssignment(int col, int val, int ... resources) {
        return this.graph.getMinMaxPathCostForAssignment(col, val, resources);
    }

    public int getMinPathCost(int ... resources) {
        return this.graph.getMinPathCost(resources);
    }

    public double[] getInstantiatedLayerCosts(int layer) {
        return this.graph.getInstantiatedLayerCosts(layer);
    }

    public void forcePathRecomputation() throws ContradictionException {
        this.lastWorld = Integer.MAX_VALUE;
        this.checkWorld();
    }
}

