## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(vaccinationimpact)

## ----example------------------------------------------------------------------
data(coverage_and_incidence_mock_data)
coverage <- coverage_and_incidence_mock_data$coverage_data
incidence <- coverage_and_incidence_mock_data$incidence_data

## -----------------------------------------------------------------------------
head(coverage)

## -----------------------------------------------------------------------------
head(incidence)

## -----------------------------------------------------------------------------
data(ve_mock_data)
head(ve_mock_data)

## -----------------------------------------------------------------------------
vaccine_effectiveness <- ve_mock_data$ve

nae <- compute_events_averted_by_vaccination(
  number_of_events = incidence$events,
  cumulative_coverage = coverage$cumulative_coverage,
  vaccine_effectiveness = vaccine_effectiveness
)
plot(nae, type = "l", xlab = "Time", ylab = "Events averted")

## -----------------------------------------------------------------------------
nabe <- compute_events_avertable_by_increasing_coverage(
  number_of_events = incidence$events,
  cumulative_coverage = coverage$cumulative_coverage,
  vaccine_coverage_increase = 0.1, # 10% increase in final coverage
  vaccine_effectiveness = vaccine_effectiveness
)

## -----------------------------------------------------------------------------
plot(nabe$new_vaccine_coverage, type = "l", xlab = "Time", ylab = "Vaccine coverage with 10% increase")

## -----------------------------------------------------------------------------
plot(nabe$nabe, type = "l", xlab = "Time", ylab = "Events averted")

## -----------------------------------------------------------------------------
sample_size <- 1234

nnv <- compute_number_needed_to_vaccinate_machado(
  number_of_events = incidence$events,
  number_of_events_averted = nae,
  population_size = sample_size,
  vaccine_effectiveness = vaccine_effectiveness
)
nnv

## -----------------------------------------------------------------------------
nnv <- compute_number_needed_to_vaccinate_tuite_fisman(
  number_of_vaccinated = cumsum(coverage$number_of_vaccinated),
  number_of_events_averted = nae
)
nnv

