/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.sat;

import org.chocosolver.sat.Clause;
import org.chocosolver.solver.ICause;

public abstract class Reason
implements ICause {
    static final Clause UNDEF = new Clause(new int[]{0});
    private static final ThreadLocal<Clause> short_expl_2 = ThreadLocal.withInitial(() -> new Clause(new int[]{0, 0}));
    private static final ThreadLocal<Clause> short_expl_3 = ThreadLocal.withInitial(() -> new Clause(new int[]{0, 0, 0}));
    final int type;

    Reason(int type) {
        this.type = type;
    }

    public static Reason undef() {
        return UNDEF;
    }

    public static Reason r(Clause cl) {
        return cl;
    }

    public static Reason r(int p) {
        return new Reason1(p);
    }

    public static Reason r(int p, int q) {
        return new Reason2(p, q);
    }

    public static Reason r(int ... ps) {
        if (ps.length == 1) {
            return new Reason1(ps[0]);
        }
        if (ps.length == 2) {
            return new Reason2(ps[0], ps[1]);
        }
        if (ps.length > 2) {
            assert (ps[0] == 0) : "The first literal should be left empty for the asserting literal";
            return new Clause(ps);
        }
        return UNDEF;
    }

    public static Reason gather(Reason r, int p) {
        switch (r.type) {
            case 0: {
                Clause cl = (Clause)r;
                int[] ps = new int[cl.size() + 1];
                for (int i = 0; i < cl.size(); ++i) {
                    ps[i] = cl._g(i);
                }
                ps[cl.size()] = p;
                return Reason.r(ps);
            }
            case 2: {
                return Reason.r(((Reason1)r).d1, p);
            }
            case 3: {
                int[] ps = new int[]{0, ((Reason2)r).d1, ((Reason2)r).d2, p};
                return Reason.r(ps);
            }
        }
        return Reason.r(p);
    }

    abstract Clause getConflict();

    static final class Reason1
    extends Reason {
        final int d1;

        private Reason1(int d1) {
            super(2);
            this.d1 = d1;
        }

        @Override
        public Clause getConflict() {
            ((Clause)short_expl_2.get())._s(1, this.d1);
            return (Clause)short_expl_2.get();
        }

        public String toString() {
            return "lit:" + this.d1;
        }
    }

    static final class Reason2
    extends Reason {
        final int d1;
        final int d2;

        private Reason2(int d1, int d2) {
            super(3);
            this.d1 = d1;
            this.d2 = d2;
        }

        @Override
        public Clause getConflict() {
            ((Clause)short_expl_3.get())._s(1, this.d1);
            ((Clause)short_expl_3.get())._s(2, this.d2);
            return (Clause)short_expl_3.get();
        }

        public String toString() {
            return "lits:" + this.d1 + " \u2228 " + this.d2;
        }
    }
}

